/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.helper;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.horseowner.HorseOwnerProvider;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.HorseProvider;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;
import tschipp.callablehorses.common.worlddata.StoredHorsesWorldData;
import tschipp.callablehorses.network.HorseCapSyncPacket;

public class HorseHelper {
    public static IHorseOwner getOwnerCap(EntityPlayer player) {
        return (IHorseOwner)player.getCapability(HorseOwnerProvider.OWNER_CAPABILITY, null);
    }

    public static IStoredHorse getHorseCap(Entity horse) {
        return (IStoredHorse)horse.getCapability(HorseProvider.HORSE_CAPABILITY, null);
    }

    public static void sendHorseUpdateInRange(Entity horse) {
        IStoredHorse storedHorse = HorseHelper.getHorseCap(horse);
        CallableHorses.network.sendToAllAround((IMessage)new HorseCapSyncPacket(horse.func_145782_y(), storedHorse), new NetworkRegistry.TargetPoint(horse.field_70170_p.field_73011_w.getDimension(), horse.field_70165_t, horse.field_70161_v, horse.field_70161_v, 32.0));
    }

    public static void sendHorseUpdateToClient(Entity horse, EntityPlayer player) {
        IStoredHorse storedHorse = HorseHelper.getHorseCap(horse);
        CallableHorses.network.sendTo((IMessage)new HorseCapSyncPacket(horse.func_145782_y(), storedHorse), (EntityPlayerMP)player);
    }

    @Nullable
    public static EntityPlayer getPlayerFromUUID(String uuid, World world) {
        MinecraftServer server = ((WorldServer)world).func_73046_m();
        EntityPlayerMP owner = server.func_184103_al().func_177451_a(UUID.fromString(uuid));
        return owner;
    }

    public static void setHorseNum(World world, String storageid, int num) {
        StoredHorsesWorldData storedHorses = StoredHorsesWorldData.getInstance(world);
        storedHorses.addHorseNum(storageid, num);
    }

    public static int getHorseNum(World world, String storageid) {
        StoredHorsesWorldData storedHorses = StoredHorsesWorldData.getInstance(world);
        return storedHorses.getHorseNum(storageid);
    }

    public static void setHorseLastSeen(EntityPlayer player) {
        IHorseOwner owner = HorseHelper.getOwnerCap(player);
        owner.setLastSeenPosition(player.func_180425_c());
        owner.setLastSeenDim(player.field_70170_p.field_73011_w.getDimension());
    }

    public static StoredHorsesWorldData getWorldData(World world) {
        return StoredHorsesWorldData.getInstance(world);
    }
}

