/*
 * Decompiled with CFR 0.152.
 */
package tschipp.callablehorses.common.capabilities.horseowner;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import tschipp.callablehorses.CallableHorses;
import tschipp.callablehorses.common.capabilities.horseowner.IHorseOwner;
import tschipp.callablehorses.common.capabilities.storedhorse.HorseProvider;
import tschipp.callablehorses.common.capabilities.storedhorse.IStoredHorse;

public class HorseOwner
implements IHorseOwner {
    private int horseNum = 0;
    private NBTTagCompound horseNBT = new NBTTagCompound();
    private String storageUUID = "";
    private int lastSeenDim = 0;
    private BlockPos lastSeenPos = BlockPos.field_177992_a;

    @Override
    public AbstractHorse getHorseEntity(World world) {
        Entity entity = EntityList.func_75615_a((NBTTagCompound)this.horseNBT, (World)world);
        if (entity instanceof AbstractHorse) {
            ++this.horseNum;
            IStoredHorse horse = (IStoredHorse)entity.getCapability(HorseProvider.HORSE_CAPABILITY, null);
            horse.setHorseNum(this.horseNum);
            entity.func_184221_a(UUID.randomUUID());
            entity.func_70066_B();
            ((AbstractHorse)entity).field_70737_aN = 0;
            entity.field_71093_bK = world.field_73011_w.getDimension();
            entity.field_71088_bW = 0;
            return (AbstractHorse)entity;
        }
        CallableHorses.LOGGER.error("The entity with NBT " + this.horseNBT.toString() + " wasn't a horse somehow?...");
        return null;
    }

    @Override
    public NBTTagCompound getHorseNBT() {
        return this.horseNBT;
    }

    @Override
    public void setHorse(AbstractHorse horse, EntityPlayer player) {
        NBTTagCompound tag;
        this.storageUUID = UUID.randomUUID().toString();
        IStoredHorse storedHorse = (IStoredHorse)horse.getCapability(HorseProvider.HORSE_CAPABILITY, null);
        storedHorse.setHorseNum(this.horseNum);
        storedHorse.setOwned(true);
        storedHorse.setOwnerUUID(player.func_146103_bH().getId().toString());
        storedHorse.setStorageUUID(this.storageUUID);
        this.horseNBT = tag = horse.serializeNBT();
    }

    @Override
    public void clearHorse() {
        this.horseNum = 0;
        this.horseNBT = new NBTTagCompound();
        this.storageUUID = "";
        this.lastSeenDim = 0;
        this.lastSeenPos = BlockPos.field_177992_a;
    }

    @Override
    public int getHorseNum() {
        return this.horseNum;
    }

    @Override
    public void setHorseNum(int num) {
        this.horseNum = num;
    }

    @Override
    public String getStorageUUID() {
        return this.storageUUID;
    }

    @Override
    public void setStorageUUID(String id) {
        this.storageUUID = id;
    }

    @Override
    public void setHorseNBT(NBTTagCompound nbt) {
        this.horseNBT = nbt;
    }

    @Override
    public void setLastSeenPosition(BlockPos pos) {
        this.lastSeenPos = pos;
    }

    @Override
    public BlockPos getLastSeenPosition() {
        return this.lastSeenPos;
    }

    @Override
    public int getLastSeenDim() {
        return this.lastSeenDim;
    }

    @Override
    public void setLastSeenDim(int i) {
        this.lastSeenDim = i;
    }
}

