/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementManager;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementTreeNode;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.command.FunctionObject;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class AdvancementHelper {
    public static final AdvancementList ADVANCEMENTS = (AdvancementList)ReflectionHelper.getPrivateValue(AdvancementManager.class, null, (String[])new String[]{"ADVANCEMENT_LIST", "field_192784_c"});
    private static final Map<ResourceLocation, Advancement.Builder> TO_REGISTER = new HashMap<ResourceLocation, Advancement.Builder>();
    private static Constructor<Advancement.Builder> ctr = null;

    public static void preInit(FMLPreInitializationEvent e) {
        AdvancementHelper.reload();
        MinecraftForge.EVENT_BUS.register((Object)new AdvancementHelper());
    }

    public static void addAdvancements() {
        new AdvancementBuilderBuilder("placebo", "test").setDisplayInfo(AdvancementHelper.createDisplay("test.title", "test.desc", new ItemStack(Items.field_151034_e), null, FrameType.TASK, true, true, false)).setRewards(AdvancementHelper.createRewards(50.0f)).setParent("adventure/root").addCriteria("test_crit", (ICriterionInstance)new KilledTrigger.Instance(CriteriaTriggers.field_192122_b.func_192163_a(), EntityPredicate.field_192483_a, DamageSourcePredicate.field_192449_a)).addConditionGroup("test_crit").build().register();
    }

    @SubscribeEvent
    public void worldServerCaps(AttachCapabilitiesEvent<World> e) {
        World world = (World)e.getObject();
        ReflectionHelper.setPrivateValue(World.class, (Object)world, (Object)((Object)new HackedAdvancementManager(new File(new File(world.func_72860_G().func_75765_b(), "data"), "advancements"))), (String[])new String[]{"advancementManager", "field_191951_C"});
    }

    public static void reload() {
        TO_REGISTER.clear();
        AdvancementHelper.addAdvancements();
        ADVANCEMENTS.func_192083_a(TO_REGISTER);
        for (Advancement advancement : ADVANCEMENTS.func_192088_b()) {
            if (advancement.func_192068_c() == null) continue;
            AdvancementTreeNode.func_192323_a((Advancement)advancement);
        }
    }

    public static Advancement.Builder genBuilder(@Nullable ResourceLocation parent, @Nullable DisplayInfo info, AdvancementRewards rewards, Map<String, Criterion> criteria, String[][] requirements) {
        if (ctr == null) {
            try {
                ctr = Advancement.Builder.class.getDeclaredConstructors()[0];
                ctr.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to access Advancement.Builder constructor!");
            }
        }
        try {
            return ctr.newInstance(new Object[]{parent, info, rewards, criteria, requirements});
        }
        catch (Exception e) {
            throw new RuntimeException("Failed instantiate Advancement.Builder!");
        }
    }

    public static DisplayInfo createDisplay(String langKey, String descKey, ItemStack stack, String background, FrameType type, boolean toast, boolean announce, boolean hidden) {
        return new DisplayInfo(stack, (ITextComponent)new TextComponentTranslation(langKey, new Object[0]), (ITextComponent)new TextComponentTranslation(descKey, new Object[0]), background == null || background.isEmpty() ? null : new ResourceLocation(background), type, toast, announce, hidden);
    }

    public static AdvancementRewards createRewards(float experience, String[] lootTables, String[] recipeNames, FunctionObject.CacheableFunction func) {
        int i;
        ResourceLocation[] tables = new ResourceLocation[lootTables.length];
        ResourceLocation[] recipes = new ResourceLocation[recipeNames.length];
        for (i = 0; i < lootTables.length; ++i) {
            tables[i] = new ResourceLocation(lootTables[i]);
        }
        for (i = 0; i < recipeNames.length; ++i) {
            recipes[i] = new ResourceLocation(recipeNames[i]);
        }
        return new AdvancementRewards(0, tables, recipes, func);
    }

    public static AdvancementRewards createRewards(float experience, String[] lootTables, String[] recipeNames) {
        return AdvancementHelper.createRewards(experience, lootTables, recipeNames, FunctionObject.CacheableFunction.field_193519_a);
    }

    public static AdvancementRewards createRewards(float experience, String[] lootTables) {
        return AdvancementHelper.createRewards(experience, lootTables, new String[0]);
    }

    public static AdvancementRewards createRewards(float experience) {
        return AdvancementHelper.createRewards(experience, new String[0]);
    }

    public static void registerAdvancement(ResourceLocation name, Advancement.Builder b) {
        if (TO_REGISTER.get(name) != null) {
            throw new RuntimeException("Attempted to register duplicate advancement! Name: " + name.toString());
        }
        TO_REGISTER.put(name, b);
    }

    public static class HackedAdvancementManager
    extends AdvancementManager {
        public HackedAdvancementManager(File advancementsDirIn) {
            super(advancementsDirIn);
        }

        public void func_192779_a() {
            super.func_192779_a();
            AdvancementHelper.reload();
        }
    }

    public static class BuilderResult {
        public final Advancement.Builder builder;
        public final ResourceLocation name;

        public BuilderResult(ResourceLocation name, Advancement.Builder builder) {
            this.name = name;
            this.builder = builder;
        }

        public void register() {
            AdvancementHelper.registerAdvancement(this.name, this.builder);
        }
    }

    public static class AdvancementBuilderBuilder {
        private DisplayInfo info;
        private AdvancementRewards rewards;
        private Map<String, Criterion> criteria = new HashMap<String, Criterion>();
        private ResourceLocation parent;
        private final List<String[]> REQUIRED = new ArrayList<String[]>();
        private final ResourceLocation name;

        public AdvancementBuilderBuilder(ResourceLocation name) {
            this.name = name;
        }

        public AdvancementBuilderBuilder(String modid, String name) {
            this(new ResourceLocation(modid, name));
        }

        public AdvancementBuilderBuilder setDisplayInfo(DisplayInfo info) {
            if (this.info != null) {
                throw new RuntimeException("Tried to set display info when it was already set!");
            }
            this.info = info;
            return this;
        }

        public AdvancementBuilderBuilder addCriteria(String name, ICriterionInstance criterion) {
            this.criteria.put(name, new Criterion(criterion));
            return this;
        }

        public AdvancementBuilderBuilder setRewards(AdvancementRewards rewards) {
            if (this.rewards != null) {
                throw new RuntimeException("Tried to set rewards when it was already set!");
            }
            this.rewards = rewards;
            return this;
        }

        public AdvancementBuilderBuilder setParent(String advancement) {
            this.parent = new ResourceLocation(advancement);
            return this;
        }

        public AdvancementBuilderBuilder addConditionGroup(String ... group) {
            this.REQUIRED.add(group);
            return this;
        }

        public BuilderResult build() {
            String[][] reqs = new String[this.REQUIRED.size()][];
            for (int i = 0; i < this.REQUIRED.size(); ++i) {
                reqs[i] = this.REQUIRED.get(i);
            }
            return new BuilderResult(this.name, AdvancementHelper.genBuilder(this.parent, this.info, this.rewards, this.criteria, reqs));
        }
    }
}

