/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.server.services;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityDimensionInfo;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfo;
import org.orecruncher.dsurround.lib.compat.ModEnvironment;
import org.orecruncher.dsurround.server.services.Service;
import org.orecruncher.dsurround.server.services.WeatherGenerator;
import org.orecruncher.dsurround.server.services.WeatherGeneratorNether;
import org.orecruncher.dsurround.server.services.WeatherGeneratorNone;
import org.orecruncher.dsurround.server.services.WeatherGeneratorVanilla;

public final class AtmosphereService
extends Service {
    private final Int2ObjectOpenHashMap<WeatherGenerator> generators = new Int2ObjectOpenHashMap();

    AtmosphereService() {
        super("AtmosphereService");
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void tickEvent(@Nonnull TickEvent.WorldTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            this.getGenerator(event.world).update();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        this.getGenerator(world);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldUnload(WorldEvent.Unload e) {
        World world = e.getWorld();
        if (world.field_72995_K) {
            return;
        }
        int dimId = world.field_73011_w.getDimension();
        this.generators.remove(dimId);
    }

    private WeatherGenerator getGenerator(@Nonnull World world) {
        int dimId = world.field_73011_w.getDimension();
        WeatherGenerator result = (WeatherGenerator)this.generators.get(dimId);
        if (result == null) {
            result = this.createGenerator(world);
            this.generators.put(dimId, (Object)result);
        }
        return result;
    }

    private boolean doVanillaRain() {
        return ModOptions.rain.doVanillaRain || ModEnvironment.Weather2.isLoaded();
    }

    private WeatherGenerator createGenerator(@Nonnull World world) {
        WeatherGenerator result = null;
        IDimensionInfo info = CapabilityDimensionInfo.getCapability(world);
        if (info != null && info.hasWeather()) {
            int dimId = world.field_73011_w.getDimension();
            if (this.doVanillaRain()) {
                if (dimId != -1) {
                    result = new WeatherGeneratorVanilla(world);
                }
            } else {
                result = dimId == -1 ? new WeatherGeneratorNether(world) : new WeatherGenerator(world);
            }
        }
        if (result == null) {
            result = new WeatherGeneratorNone(world);
        }
        ModBase.log().info("Creating %s weather generator for dimension [%s]", new Object[]{((WeatherGenerator)result).name(), world.field_73011_w.func_186058_p().func_186065_b()});
        return result;
    }
}

