/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.World;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.registry.Registry;
import org.orecruncher.dsurround.registry.config.DimensionConfig;
import org.orecruncher.dsurround.registry.config.ModConfiguration;
import org.orecruncher.lib.logging.ModLog;

public final class DimensionRegistry
extends Registry {
    private final List<DimensionConfig> cache = new ArrayList<DimensionConfig>();

    public DimensionRegistry() {
        super("Dimension Registry");
    }

    @Override
    protected void preInit() {
        this.cache.clear();
    }

    @Override
    protected void init(@Nonnull ModConfiguration cfg) {
        cfg.dimensions.forEach(this::register);
    }

    @Override
    protected void complete() {
        if (ModOptions.logging.enableDebugLogging) {
            ModBase.log().info("*** DIMENSION REGISTRY (cache) ***", new Object[0]);
            this.cache.stream().map(Object::toString).forEach(arg_0 -> DimensionRegistry.lambda$complete$0(ModBase.log(), arg_0));
        }
    }

    public void loading(@Nonnull World world) {
        this.getData(world);
    }

    @Nonnull
    private DimensionConfig getData(@Nonnull DimensionConfig entry) {
        Optional<DimensionConfig> result = this.cache.stream().filter(e -> e.equals(entry)).findFirst();
        if (result.isPresent()) {
            return result.get();
        }
        this.cache.add(entry);
        return entry;
    }

    public void register(@Nonnull DimensionConfig entry) {
        if (entry.dimensionId != null || entry.name != null) {
            DimensionConfig data = this.getData(entry);
            if (data == entry) {
                return;
            }
            if (data.dimensionId == null) {
                data.dimensionId = entry.dimensionId;
            }
            if (data.name == null) {
                data.name = entry.name;
            }
            if (entry.hasAurora != null) {
                data.hasAurora = entry.hasAurora;
            }
            if (entry.hasHaze != null) {
                data.hasHaze = entry.hasHaze;
            }
            if (entry.hasWeather != null) {
                data.hasWeather = entry.hasWeather;
            }
            if (entry.cloudHeight != null) {
                data.cloudHeight = entry.cloudHeight;
            }
            if (entry.seaLevel != null) {
                data.seaLevel = entry.seaLevel;
            }
            if (entry.skyHeight != null) {
                data.skyHeight = entry.skyHeight;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DimensionConfig getData(@Nonnull World world) {
        DimensionRegistry dimensionRegistry = this;
        synchronized (dimensionRegistry) {
            for (DimensionConfig e : this.cache) {
                if ((e.dimensionId == null || e.dimensionId.intValue() != world.field_73011_w.getDimension()) && (e.name == null || !e.name.equals(world.field_73011_w.func_186058_p().func_186065_b()))) continue;
                return e;
            }
            return null;
        }
    }

    private static /* synthetic */ void lambda$complete$0(ModLog rec$, String x$0) {
        rec$.info(x$0, new Object[0]);
    }
}

