/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.proxy;

import java.util.Arrays;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.command.ICommand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IThreadListener;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityEntityFXData;
import org.orecruncher.dsurround.capabilities.CapabilitySeasonInfo;
import org.orecruncher.dsurround.capabilities.CapabilitySpeechData;
import org.orecruncher.dsurround.client.fx.ParticleCollections;
import org.orecruncher.dsurround.client.fx.particle.ParticleDripOverride;
import org.orecruncher.dsurround.client.gui.HumDinger;
import org.orecruncher.dsurround.client.handlers.EffectManager;
import org.orecruncher.dsurround.client.hud.GuiHUDHandler;
import org.orecruncher.dsurround.client.hud.InspectionHUD;
import org.orecruncher.dsurround.client.keyboard.KeyHandler;
import org.orecruncher.dsurround.client.renderer.AnimaniaBadge;
import org.orecruncher.dsurround.client.renderer.weather.RenderWeather;
import org.orecruncher.dsurround.client.sound.BackgroundMute;
import org.orecruncher.dsurround.client.sound.SoundEngine;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.commands.CommandCalc;
import org.orecruncher.dsurround.event.WorldEventDetector;
import org.orecruncher.dsurround.lib.compat.ModEnvironment;
import org.orecruncher.dsurround.proxy.IProxy;
import org.orecruncher.dsurround.proxy.Proxy;
import org.orecruncher.dsurround.registry.RegistryDataEvent;
import org.orecruncher.lib.ForgeUtils;
import org.orecruncher.lib.Localization;
import org.orecruncher.lib.chunk.ClientChunkCache;
import org.orecruncher.lib.task.Scheduler;

@SideOnly(value=Side.CLIENT)
public class ProxyClient
extends Proxy
implements IProxy,
ISelectiveResourceReloadListener {
    @Override
    protected void registerLanguage() {
        Localization.initialize((Side)Side.CLIENT, (String)"dsurround");
    }

    @Override
    protected void eventBusRegistrations() {
        super.eventBusRegistrations();
        ProxyClient.register(HumDinger.class);
        ProxyClient.register(InspectionHUD.class);
        ProxyClient.register(KeyHandler.class);
        ProxyClient.register(BackgroundMute.class);
        ProxyClient.register(RenderWeather.class);
        ProxyClient.register(Weather.class);
        ProxyClient.register(WorldEventDetector.class);
        ProxyClient.register(ParticleCollections.class);
    }

    @Override
    public boolean isRunningAsServer() {
        return false;
    }

    @Override
    public Side effectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    @Override
    public void preInit(@Nonnull FMLPreInitializationEvent event) {
        super.preInit(event);
        CapabilitySpeechData.register();
        CapabilitySeasonInfo.register();
        CapabilityEntityFXData.register();
    }

    @Override
    public void init(@Nonnull FMLInitializationEvent event) {
        super.init(event);
        KeyHandler.init();
        ParticleDripOverride.register();
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandCalc());
        if (ModOptions.effects.disableWaterSuspendParticle) {
            Minecraft.func_71410_x().field_71452_i.func_178929_a(EnumParticleTypes.SUSPENDED.func_179348_c(), null);
        }
        if (ModEnvironment.AmbientSounds.isLoaded()) {
            SoundEngine.configureSound(null);
        }
    }

    @Override
    public void postInit(@Nonnull FMLPostInitializationEvent event) {
        super.postInit(event);
        ModMetadata data = ForgeUtils.getModMetadata((String)"dsurround");
        if (data != null) {
            data.name = Localization.loadString((String)"dsurround.metadata.Name");
            data.credits = Localization.loadString((String)"dsurround.metadata.Credits");
            data.description = Localization.loadString((String)"dsurround.metadata.Description");
            data.authorList = Arrays.asList(StringUtils.split((String)Localization.loadString((String)"dsurround.metadata.Authors"), (char)','));
        }
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        ((IReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)this);
        if (ModEnvironment.Animania.isLoaded()) {
            AnimaniaBadge.initialize();
        }
        int r = Math.max(32, ModOptions.effects.specialEffectRange);
        ClientChunkCache.initialize((int)(r += 2), (!ModOptions.general.enableClientChunkCaching ? 1 : 0) != 0);
    }

    @Override
    public void clientConnect(@Nonnull FMLNetworkEvent.ClientConnectedToServerEvent event) {
        Scheduler.schedule((Side)Side.CLIENT, () -> {
            EffectManager.connect();
            GuiHUDHandler.register();
            Weather.register(ModBase.isInstalledOnServer());
        });
    }

    @Override
    public void clientDisconnect(@Nonnull FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Scheduler.schedule((Side)Side.CLIENT, () -> {
            EffectManager.disconnect();
            GuiHUDHandler.unregister();
            Weather.unregister();
        });
    }

    public void onResourceManagerReload(@Nonnull IResourceManager resourceManager, @Nonnull Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.SOUNDS)) {
            MinecraftForge.EVENT_BUS.post((Event)new RegistryDataEvent.Resources(resourceManager));
        }
    }

    @Override
    public IThreadListener getThreadListener(@Nonnull MessageContext context) {
        if (context.side.isClient()) {
            return Minecraft.func_71410_x();
        }
        return context.getServerHandler().field_147369_b.func_184102_h();
    }
}

