/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.effects;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.EntitySelectors;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.CapabilityEntityData;
import org.orecruncher.dsurround.capabilities.entitydata.IEntityData;
import org.orecruncher.dsurround.client.effects.EntityEffect;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactory;
import org.orecruncher.dsurround.client.effects.IEntityEffectFactoryFilter;
import org.orecruncher.dsurround.client.effects.IEntityEffectHandlerState;
import org.orecruncher.dsurround.client.handlers.effects.EntityChatEffect;

@SideOnly(value=Side.CLIENT)
public class VillagerChatEffect
extends EntityEffect {
    protected final Predicate<Entity> pred;
    protected final EntityChatEffect normalChat;
    protected final EntityChatEffect fleeChat;
    protected boolean runningScared = false;
    public static final IEntityEffectFactoryFilter DEFAULT_FILTER;

    public VillagerChatEffect(@Nonnull Entity entity) {
        EntityVillager villager = (EntityVillager)entity;
        this.pred = EntitySelectors.field_188444_d.and(input -> input.func_70089_S() && villager.func_70635_at().func_75522_a(input));
        this.normalChat = new EntityChatEffect(entity);
        this.fleeChat = new EntityChatEffect(entity, "villager.flee");
    }

    @Override
    @Nonnull
    public String name() {
        return "Villager Chat";
    }

    @Override
    public void initialize(@Nonnull IEntityEffectHandlerState state) {
        super.initialize(state);
        this.normalChat.initialize(state);
        this.fleeChat.initialize(state);
    }

    @Override
    public void update(@Nonnull Entity subject) {
        if (!ModOptions.speechbubbles.enableEntityChat) {
            return;
        }
        EntityVillager entity = (EntityVillager)subject;
        if (entity.func_70631_g_()) {
            return;
        }
        if (this.villagerThreatened((Entity)entity)) {
            this.runningScared = true;
            this.fleeChat.update(subject);
        } else {
            if (this.runningScared) {
                this.runningScared = false;
                this.normalChat.genNextChatTime();
            }
            this.normalChat.update(subject);
        }
    }

    protected boolean villagerThreatened(Entity entity) {
        IEntityData data;
        if (ModBase.isInstalledOnServer() && (data = CapabilityEntityData.getCapability(entity)) != null) {
            return data.isFleeing();
        }
        for (Entity e : entity.func_130014_f_().field_72996_f) {
            if (!(e.func_70068_e(entity) <= 64.0) || !(e instanceof EntityZombie) && !(e instanceof EntityEvoker) && !(e instanceof EntityVex) && !(e instanceof EntityVindicator) || !this.pred.test(e)) continue;
            return true;
        }
        return false;
    }

    static {
        EntityChatEffect.setTimers("villager.flee", 250, 200);
        DEFAULT_FILTER = (e, eei) -> eei.effects.contains("chat") && e instanceof EntityVillager && EntityChatEffect.hasMessages(e);
    }

    public static class Factory
    implements IEntityEffectFactory {
        @Override
        @Nonnull
        public List<EntityEffect> create(@Nonnull Entity entity) {
            return ImmutableList.of((Object)new VillagerChatEffect(entity));
        }
    }
}

