/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.AreaBlockEffectsHandler;
import org.orecruncher.dsurround.client.handlers.AuroraEffectHandler;
import org.orecruncher.dsurround.client.handlers.BiomeSoundEffectsHandler;
import org.orecruncher.dsurround.client.handlers.DiagnosticHandler;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.FogHandler;
import org.orecruncher.dsurround.client.handlers.FxHandler;
import org.orecruncher.dsurround.client.handlers.ParticleSystemHandler;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.handlers.WeatherHandler;
import org.orecruncher.lib.collections.ObjectArray;
import org.orecruncher.lib.compat.EntityLivingBaseUtil;
import org.orecruncher.lib.math.TimerEMA;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="dsurround")
public class EffectManager {
    private static final EffectManager instance_ = new EffectManager();
    private static boolean isConnected = false;
    private final ObjectArray<EffectHandlerBase> effectHandlers = new ObjectArray();
    private final Map<Class<? extends EffectHandlerBase>, EffectHandlerBase> services = new Reference2ObjectOpenHashMap();
    private final TimerEMA computeTime = new TimerEMA("Processing");

    public static EffectManager instance() {
        return instance_;
    }

    private EffectManager() {
        this.init();
    }

    private void register(@Nonnull EffectHandlerBase handler) {
        this.effectHandlers.add((Object)handler);
        this.services.put(handler.getClass(), handler);
        ModBase.log().debug("Registered handler [%s]", new Object[]{handler.getClass().getName()});
    }

    private void init() {
        this.register(new EnvironStateHandler());
        this.register(new AreaBlockEffectsHandler());
        this.register(new FogHandler());
        this.register(new ParticleSystemHandler());
        this.register(new BiomeSoundEffectsHandler());
        this.register(new AuroraEffectHandler());
        this.register(new WeatherHandler());
        this.register(new FxHandler());
        this.register(SoundEffectHandler.INSTANCE);
        this.register(new DiagnosticHandler());
    }

    private void onConnect() {
        for (EffectHandlerBase h : this.effectHandlers) {
            h.connect0();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        ((DiagnosticHandler)this.lookupService(DiagnosticHandler.class)).addTimer(this.computeTime);
    }

    private void onDisconnect() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        for (EffectHandlerBase h : this.effectHandlers) {
            h.disconnect0();
        }
    }

    public <T> T lookupService(@Nonnull Class<? extends EffectHandlerBase> service) {
        EffectHandlerBase eh = this.services.get(service);
        if (eh == null) {
            ModBase.log().warn("Unable to locate handler service [%s]", new Object[]{service.getName()});
        }
        return (T)eh;
    }

    public boolean isConnected() {
        return isConnected;
    }

    public static void connect() {
        if (isConnected) {
            ModBase.log().warn("Attempt to initialize EffectManager when it is already initialized", new Object[0]);
            EffectManager.disconnect();
        }
        instance_.onConnect();
        isConnected = true;
    }

    public static void disconnect() {
        if (isConnected) {
            instance_.onDisconnect();
            isConnected = false;
        }
    }

    protected static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    protected boolean checkReady(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.side == Side.SERVER || event.phase == TickEvent.Phase.END || Minecraft.func_71410_x().func_147113_T()) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y == null) {
            return false;
        }
        if (Minecraft.func_71410_x().func_175598_ae().field_78733_k == null) {
            return false;
        }
        EntityPlayer player2 = EffectManager.getPlayer();
        return player2 != null && player2.func_130014_f_() != null;
    }

    public void onTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (!this.checkReady(event)) {
            return;
        }
        long start = System.nanoTime();
        EntityPlayer player2 = EffectManager.getPlayer();
        if (ModOptions.player.suppressPotionParticles) {
            player2.func_184212_Q().func_187227_b(EntityLivingBaseUtil.getHideParticles(), (Object)true);
        }
        int tick = EnvironStateHandler.EnvironState.getTickCounter();
        for (int i = 0; i < this.effectHandlers.size(); ++i) {
            EffectHandlerBase handler = (EffectHandlerBase)this.effectHandlers.get(i);
            long mark = System.nanoTime();
            if (handler.doTick(tick)) {
                handler.process(player2);
            }
            handler.updateTimer(System.nanoTime() - mark);
        }
        this.computeTime.update((double)(System.nanoTime() - start));
    }

    @SubscribeEvent
    public static void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (isConnected) {
            instance_.onTick(event);
        }
    }
}

