/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.footsteps;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.footsteps.facade.FacadeHelper;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.lib.WorldUtils;

@SideOnly(value=Side.CLIENT)
public final class FootStrikeLocation {
    private final EntityLivingBase entity;
    private final Vec3d strike;
    private final BlockPos stepPos;

    public FootStrikeLocation(@Nonnull EntityLivingBase entity, double x, double y, double z) {
        this(entity, new Vec3d(x, y, z));
    }

    public FootStrikeLocation(@Nonnull EntityLivingBase entity, @Nonnull Vec3d loc) {
        this.entity = entity;
        this.strike = loc;
        this.stepPos = new BlockPos(loc);
    }

    protected FootStrikeLocation(@Nonnull EntityLivingBase entity, @Nonnull Vec3d loc, @Nonnull BlockPos pos) {
        this.entity = entity;
        this.strike = loc;
        this.stepPos = pos;
    }

    public FootStrikeLocation rebase(@Nonnull BlockPos pos) {
        if (!this.stepPos.equals((Object)pos)) {
            return new FootStrikeLocation(this.entity, this.strike, pos);
        }
        return this;
    }

    @Nonnull
    public EntityLivingBase getEntity() {
        return this.entity;
    }

    @Nonnull
    public BlockPos getStepPos() {
        return this.stepPos;
    }

    @Nonnull
    public Vec3d getStrikePosition() {
        return this.strike;
    }

    public Vec3d north() {
        return this.offset(EnumFacing.NORTH, 1.0f);
    }

    public Vec3d south() {
        return this.offset(EnumFacing.SOUTH, 1.0f);
    }

    public Vec3d east() {
        return this.offset(EnumFacing.EAST, 1.0f);
    }

    public Vec3d west() {
        return this.offset(EnumFacing.WEST, 1.0f);
    }

    public Vec3d up() {
        return this.offset(EnumFacing.UP, 1.0f);
    }

    public Vec3d down() {
        return this.offset(EnumFacing.DOWN, 1.0f);
    }

    @Nonnull
    public Vec3d offset(@Nonnull EnumFacing facing, float n) {
        return n == 0.0f ? this.strike : new Vec3d(this.strike.field_72450_a + (double)((float)facing.func_82601_c() * n), this.strike.field_72448_b + (double)((float)facing.func_96559_d() * n), this.strike.field_72449_c + (double)((float)facing.func_82599_e() * n));
    }

    @Nullable
    protected Vec3d footprintPosition() {
        IBlockState state;
        World world = this.entity.func_130014_f_();
        if (this.hasFootstepImprint(world, state = WorldUtils.getBlockState((World)world, (BlockPos)this.stepPos), this.strike)) {
            double entityY = this.entity.func_174813_aQ().field_72338_b;
            double blockY = this.getBoundingBoxY(entityY, (IBlockAccess)world, state, this.stepPos);
            return new Vec3d(this.strike.field_72450_a, Math.max(entityY, blockY), this.strike.field_72449_c);
        }
        return null;
    }

    protected double getBoundingBoxY(double baseY, @Nonnull IBlockAccess world, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
        double collisionY;
        AxisAlignedBB bounding = state.func_185900_c(world, pos);
        AxisAlignedBB collision = state.func_185890_d(world, pos);
        double boundingY = bounding.field_72337_e;
        double d = collisionY = collision == null ? baseY : collision.field_72337_e;
        if (boundingY == collisionY) {
            return baseY;
        }
        return Math.max(baseY, (double)pos.func_177956_o() + Math.max(boundingY, collisionY));
    }

    protected boolean hasFootstepImprint(@Nonnull World world, @Nonnull IBlockState state, @Nonnull Vec3d pos) {
        IBlockState footstepState = FacadeHelper.resolveState(this.entity, state, (IBlockAccess)world, pos, EnumFacing.UP);
        return RegistryManager.FOOTSTEPS.hasFootprint(footstepState);
    }
}

