/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.dimension;

import java.text.DecimalFormat;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfo;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfoEx;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.config.DimensionConfig;
import org.orecruncher.lib.math.MathStuff;
import org.orecruncher.lib.random.XorShiftRandom;

public final class DimensionInfo
implements IDimensionInfoEx {
    public static final IDimensionInfo NONE = new DimensionInfo();
    public static final float MIN_INTENSITY = 0.0f;
    public static final float MAX_INTENSITY = 1.0f;
    private static final int SPACE_HEIGHT_OFFSET = 32;
    private static final DecimalFormat FORMATTER = new DecimalFormat("0");
    protected final Random RANDOM = XorShiftRandom.current();
    protected final World world;
    private float intensity = 0.0f;
    private float currentIntensity = 0.0f;
    private float minIntensity = ModOptions.rain.defaultMinRainStrength;
    private float maxIntensity = ModOptions.rain.defaultMaxRainStrength;
    private int thunderTimer = 0;
    protected final int dimensionId;
    protected final String name;
    protected int seaLevel;
    protected int skyHeight;
    protected int cloudHeight;
    protected int spaceHeight;
    protected boolean hasHaze = false;
    protected boolean hasAuroras = false;
    protected boolean hasWeather = false;
    protected boolean hasFog = false;
    protected boolean alwaysOutside = false;
    protected boolean playBiomeSounds = true;

    public DimensionInfo() {
        this.world = null;
        this.dimensionId = Integer.MIN_VALUE;
        this.name = "<DEFAULT NONE>";
    }

    public DimensionInfo(@Nonnull World world) {
        DimensionConfig entry;
        WorldType wt;
        this.world = world;
        this.dimensionId = world.field_73011_w.getDimension();
        this.name = world.field_73011_w.func_186058_p().func_186065_b();
        this.seaLevel = world.func_181545_F();
        this.cloudHeight = this.skyHeight = world.func_72940_L();
        this.spaceHeight = this.skyHeight + 32;
        if (world.field_73011_w.func_76569_d() && world.field_73011_w.func_191066_m()) {
            this.hasWeather = true;
            this.hasAuroras = true;
            this.hasFog = true;
        }
        if ((wt = world.func_175624_G()) == WorldType.field_77138_c) {
            this.seaLevel = 0;
        } else if (this.dimensionId == 0 && ModOptions.biomes.worldSealevelOverride > 0) {
            this.seaLevel = ModOptions.biomes.worldSealevelOverride;
        }
        String dim = Integer.toString(this.dimensionId);
        for (int i = 0; i < ModOptions.biomes.dimensionBlacklist.length; ++i) {
            if (!dim.equals(ModOptions.biomes.dimensionBlacklist[i])) continue;
            this.playBiomeSounds = false;
            break;
        }
        if ((entry = RegistryManager.DIMENSION.getData(this.world)) != null) {
            if (entry.seaLevel != null) {
                this.seaLevel = entry.seaLevel;
            }
            if (entry.skyHeight != null) {
                this.skyHeight = entry.skyHeight;
            }
            if (entry.hasHaze != null) {
                this.hasHaze = entry.hasHaze;
            }
            if (entry.hasAurora != null) {
                this.hasAuroras = entry.hasAurora;
            }
            if (entry.hasWeather != null) {
                this.hasWeather = entry.hasWeather;
            }
            if (entry.cloudHeight != null) {
                this.cloudHeight = entry.cloudHeight;
            } else {
                int n = this.cloudHeight = this.hasHaze ? this.skyHeight / 2 : this.skyHeight;
            }
            if (entry.hasFog != null) {
                this.hasFog = entry.hasFog;
            }
            if (entry.alwaysOutside != null) {
                this.alwaysOutside = entry.alwaysOutside;
            }
            this.spaceHeight = this.skyHeight + 32;
        }
    }

    @Override
    public int getId() {
        return this.dimensionId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public int getSeaLevel() {
        return this.seaLevel;
    }

    @Override
    public int getSkyHeight() {
        return this.skyHeight;
    }

    @Override
    public int getCloudHeight() {
        return this.cloudHeight;
    }

    @Override
    public int getSpaceHeight() {
        return this.spaceHeight;
    }

    @Override
    public boolean hasHaze() {
        return this.hasHaze;
    }

    @Override
    public boolean hasAuroras() {
        return this.hasAuroras;
    }

    @Override
    public boolean hasWeather() {
        return this.hasWeather;
    }

    @Override
    public boolean hasFog() {
        return this.hasFog;
    }

    @Override
    public boolean playBiomeSounds() {
        return this.playBiomeSounds;
    }

    @Override
    public boolean alwaysOutside() {
        return this.alwaysOutside;
    }

    @Override
    public float getRainIntensity() {
        return this.intensity;
    }

    @Override
    public float getCurrentRainIntensity() {
        return this.currentIntensity;
    }

    @Override
    public void setRainIntensity(float intensity) {
        this.intensity = MathStuff.clamp((float)intensity, (float)0.0f, (float)1.0f);
    }

    @Override
    public void setCurrentRainIntensity(float intensity) {
        this.currentIntensity = MathStuff.clamp((float)intensity, (float)0.0f, (float)this.intensity);
    }

    @Override
    public float getMinRainIntensity() {
        return this.minIntensity;
    }

    @Override
    public void setMinRainIntensity(float intensity) {
        this.minIntensity = MathStuff.clamp((float)intensity, (float)0.0f, (float)this.maxIntensity);
    }

    @Override
    public float getMaxRainIntensity() {
        return this.maxIntensity;
    }

    @Override
    public void setMaxRainIntensity(float intensity) {
        this.maxIntensity = MathStuff.clamp((float)intensity, (float)this.minIntensity, (float)1.0f);
    }

    @Override
    public int getThunderTimer() {
        return this.thunderTimer;
    }

    @Override
    public void setThunderTimer(int time) {
        this.thunderTimer = MathStuff.clamp((int)time, (int)0, (int)Integer.MAX_VALUE);
    }

    @Override
    public void randomizeRain() {
        float result;
        float delta = this.maxIntensity - this.minIntensity;
        if (delta <= 0.0f) {
            result = this.minIntensity;
        } else {
            float mid = delta / 2.0f;
            result = this.minIntensity + this.RANDOM.nextFloat() * mid + this.RANDOM.nextFloat() * mid;
        }
        this.setRainIntensity(MathStuff.clamp((float)result, (float)0.01f, (float)1.0f));
        this.setCurrentRainIntensity(0.0f);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74776_a("i", this.getRainIntensity());
        nbt.func_74776_a("ci", this.getCurrentRainIntensity());
        nbt.func_74776_a("min", this.getMinRainIntensity());
        nbt.func_74776_a("max", this.getMaxRainIntensity());
        nbt.func_74768_a("th", this.getThunderTimer());
        return nbt;
    }

    public void deserializeNBT(@Nonnull NBTTagCompound nbt) {
        this.setRainIntensity(nbt.func_74760_g("i"));
        this.setCurrentRainIntensity(nbt.func_74760_g("ci"));
        this.setMinRainIntensity(nbt.func_74760_g("min"));
        this.setMaxRainIntensity(nbt.func_74760_g("max"));
        this.setThunderTimer(nbt.func_74762_e("th"));
    }

    @Override
    @Nonnull
    public String configString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dim ").append(this.getId()).append(": ");
        builder.append("rainIntensity [").append(FORMATTER.format(this.getMinRainIntensity() * 100.0f));
        builder.append(",").append(FORMATTER.format(this.getMaxRainIntensity() * 100.0f));
        builder.append("]");
        return builder.toString();
    }

    @Nonnull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("dim ").append(this.getId()).append(": ");
        builder.append("rainIntensity: ").append(FORMATTER.format(this.getRainIntensity() * 100.0f));
        builder.append('/').append(FORMATTER.format(this.getCurrentRainIntensity() * 100.0f));
        builder.append(" [").append(FORMATTER.format(this.getMinRainIntensity() * 100.0f));
        builder.append(",").append(FORMATTER.format(this.getMaxRainIntensity() * 100.0f));
        builder.append("], thunderTimer: ").append(this.getThunderTimer());
        return builder.toString();
    }

    private static final class NBT {
        public static final String INTENSITY = "i";
        public static final String CURRENT_INTENSITY = "ci";
        public static final String MIN_INTENSITY = "min";
        public static final String MAX_INTENSITY = "max";
        public static final String THUNDER_TIMER = "th";

        private NBT() {
        }
    }
}

