/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.lib.util.ChatHelper;
import net.silentchaos512.lib.util.Color;
import net.silentchaos512.lib.util.EntityHelper;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.config.Config;
import net.silentchaos512.scalinghealth.init.ModSounds;
import net.silentchaos512.scalinghealth.lib.EnumModParticles;
import net.silentchaos512.scalinghealth.network.NetworkHandler;
import net.silentchaos512.scalinghealth.network.message.MessageDataSync;
import net.silentchaos512.scalinghealth.utils.SHPlayerDataHandler;

public class ItemHeartContainer
extends Item {
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        list.add(ScalingHealth.i18n.subText((IForgeRegistryEntry)this, "desc", new Object[0]));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            boolean consumed;
            SHPlayerDataHandler.PlayerData data = SHPlayerDataHandler.get(player);
            if (data == null) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            boolean healthIncreaseAllowed = ItemHeartContainer.isHealthIncreaseAllowed(data);
            int levelRequirement = ItemHeartContainer.getLevelsRequiredToUse(player, stack, healthIncreaseAllowed);
            if (player.field_71068_ca < levelRequirement) {
                ChatHelper.translateStatus((EntityPlayer)player, (String)ScalingHealth.i18n.getKey((IForgeRegistryEntry)this, "notEnoughXP"), (boolean)true, (Object[])new Object[]{levelRequirement});
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            boolean bl = consumed = Config.Items.Heart.healthRestored > 0 && player.func_110143_aJ() < player.func_110138_aP();
            if (consumed) {
                ItemHeartContainer.doExtraHealing(player);
            }
            if (!healthIncreaseAllowed) {
                return this.useAsHealingItem(world, player, stack, levelRequirement, consumed);
            }
            this.useForHealthIncrease(world, player, stack, data, levelRequirement);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    private static void doExtraHealing(EntityPlayer player) {
        int current = (int)player.func_110143_aJ();
        EntityHelper.heal((EntityLivingBase)player, (float)Config.Items.Heart.healthRestored, (boolean)Config.Items.Heart.healingEvent);
        int newHealth = (int)player.func_110143_aJ();
        if (current + Config.Items.Heart.healthRestored != newHealth) {
            ScalingHealth.logHelper.warn("Another mod seems to have canceled healing from a heart container (player {})", new Object[]{player.func_70005_c_()});
        }
    }

    private void incrementUseStat(EntityPlayer player) {
        StatBase useStat = StatList.func_188057_b((Item)this);
        if (useStat != null) {
            player.func_71029_a(useStat);
        }
    }

    @Nonnull
    private ActionResult<ItemStack> useAsHealingItem(World world, EntityPlayer player, ItemStack stack, int levelRequirement, boolean consumed) {
        if (consumed) {
            world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, 1.0f + 0.1f * (float)ScalingHealth.random.nextGaussian());
            stack.func_190918_g(1);
            ItemHeartContainer.consumeLevels(player, levelRequirement);
            this.incrementUseStat(player);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    private void useForHealthIncrease(World world, EntityPlayer player, ItemStack stack, SHPlayerDataHandler.PlayerData data, int levelRequirement) {
        data.incrementMaxHealth(2.0f);
        stack.func_190918_g(1);
        ItemHeartContainer.spawnParticlesAndPlaySound(world, player);
        ItemHeartContainer.consumeLevels(player, levelRequirement);
        this.incrementUseStat(player);
        NetworkHandler.INSTANCE.sendTo((IMessage)new MessageDataSync(data, player), (EntityPlayerMP)player);
    }

    private static int getLevelsRequiredToUse(EntityPlayer player, ItemStack stack, boolean healthIncreaseAllowed) {
        return player.field_71075_bZ.field_75098_d ? 0 : Config.Items.Heart.xpCost;
    }

    private static void consumeLevels(EntityPlayer player, int amount) {
        player.field_71068_ca -= amount;
    }

    private static boolean isHealthIncreaseAllowed(SHPlayerDataHandler.PlayerData data) {
        return Config.Items.Heart.increaseHealth && (Config.Player.Health.maxHealth == 0 || data.getMaxHealth() < (float)Config.Player.Health.maxHealth);
    }

    private static void spawnParticlesAndPlaySound(World world, EntityPlayer player) {
        double particleX = player.field_70165_t;
        double particleY = player.field_70163_u + (double)(0.65f * player.field_70131_O);
        double particleZ = player.field_70161_v;
        for (int i = 0; i < 40 - 10 * ScalingHealth.proxy.getParticleSettings(); ++i) {
            double xSpeed = 0.08 * ScalingHealth.random.nextGaussian();
            double ySpeed = 0.05 * ScalingHealth.random.nextGaussian();
            double zSpeed = 0.08 * ScalingHealth.random.nextGaussian();
            ScalingHealth.proxy.spawnParticles(EnumModParticles.HEART_CONTAINER, new Color(1.0f, 0.0f, 0.0f), world, particleX, particleY, particleZ, xSpeed, ySpeed, zSpeed);
        }
        ScalingHealth.proxy.playSoundOnClient(player, ModSounds.HEART_CONTAINER_USE, 0.5f, 1.0f + 0.1f * (float)ScalingHealth.random.nextGaussian());
    }
}

