/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.scalinghealth.item;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.silentchaos512.lib.registry.ICustomModel;
import net.silentchaos512.scalinghealth.ScalingHealth;
import net.silentchaos512.scalinghealth.init.ModPotions;

public class ItemHealing
extends Item
implements ICustomModel {
    private static final int USE_TIME = 100;

    public ItemHealing() {
        this.func_77625_d(4);
        this.func_77627_a(true);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 100;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_110143_aJ() < player.func_110138_aP() && !player.func_70644_a((Potion)ModPotions.bandaged)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (!world.field_72995_K) {
            Type healingType = Type.clampMeta(stack.func_77952_i());
            entityLiving.func_70690_d(new PotionEffect((Potion)ModPotions.bandaged, healingType.effectDuration, healingType.amplifier, false, false));
            stack.func_190918_g(1);
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (count % 10 == 0) {
            player.func_184185_a(SoundEvents.field_187728_s, 1.25f, (float)((double)1.1f + (double)0.05f * ScalingHealth.random.nextGaussian()));
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Type type : Type.values()) {
            list.add((Object)new ItemStack((Item)this, 1, type.ordinal()));
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        Type healingType = Type.clampMeta(stack.func_77952_i());
        list.add(ScalingHealth.i18n.itemSubText("healingitem", "healingValue", new Object[]{(int)(healingType.healPercentage * 100.0f), healingType.effectDuration / 20}));
        list.add(ScalingHealth.i18n.itemSubText("healingitem", "howToUse", new Object[]{5}));
    }

    public String func_77667_c(ItemStack stack) {
        return ScalingHealth.i18n.getKey("item", Type.clampMeta(stack.func_77952_i()).getItemName());
    }

    public void registerModels() {
        for (Type type : Type.values()) {
            ScalingHealth.registry.setModel((Item)this, type.getItemDamage(), type.getItemName());
        }
    }

    public static enum Type {
        BANDAGE(0.3f, 1),
        MEDKIT(0.7f, 4);

        public final float healPercentage;
        public final int effectDuration;
        public final int amplifier;

        private Type(float healPercentage, int speed) {
            this.healPercentage = healPercentage;
            this.effectDuration = (int)(healPercentage * 100.0f * 20.0f * 2.0f / (float)speed);
            this.amplifier = speed - 1;
        }

        public static Type clampMeta(int unclampedMetadata) {
            return Type.values()[MathHelper.func_76125_a((int)unclampedMetadata, (int)0, (int)(Type.values().length - 1))];
        }

        public String getItemName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public int getItemDamage() {
            return this.ordinal();
        }
    }
}

