/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.buildcraft;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.deco.collection.DecoCollectionDesert;
import rtg.api.world.deco.collection.DecoCollectionDesertRiver;
import rtg.api.world.gen.RTGChunkGenSettings;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.buildcraft.RealisticBiomeBCBase;

public class RealisticBiomeBCDesertOilField
extends RealisticBiomeBCBase {
    public RealisticBiomeBCDesertOilField(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
        this.getConfig().addProperty(this.getConfig().ALLOW_CACTUS).set(true);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBCOilDesert();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBCOilDesert(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B);
    }

    @Override
    public void rReplace(ChunkPrimer primer, int i, int j, int x, int y, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
        this.rReplaceWithRiver(primer, i, j, x, y, depth, rtgWorld, noise, river, base);
    }

    @Override
    public void initDecos() {
        super.initDecos();
        this.addDecoCollection(new DecoCollectionDesertRiver(this.getConfig()));
        this.addDecoCollection(new DecoCollectionDesert(this.getConfig()));
    }

    @Override
    public void overrideDecorations() {
        this.baseBiome().field_76760_I.field_76800_F = -999;
    }

    public static class SurfaceBCOilDesert
    extends SurfaceBase {
        public SurfaceBCOilDesert(BiomeConfig config, IBlockState top, IBlockState fill) {
            super(config, top, fill);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            boolean water = false;
            boolean riverPaint = false;
            boolean grass = false;
            if (river > 0.05f && river + simplex.noise2f((float)i / 10.0f, (float)j / 10.0f) * 0.1f > 0.86f) {
                riverPaint = true;
                if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > 0.25f) {
                    grass = true;
                }
            }
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (riverPaint) {
                    if (grass && depth < 4) {
                        primer.func_177855_a(x, k, z, this.fillerBlock);
                        continue;
                    }
                    if (depth != 0) continue;
                    primer.func_177855_a(x, k, z, rand.nextInt(2) == 0 ? this.topBlock : Blocks.field_150322_A.func_176223_P());
                    continue;
                }
                if (depth > -1 && depth < 5) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 8) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBCOilDesert
    extends TerrainBase {
        public TerrainBCOilDesert() {
            super(64.0f);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            RTGChunkGenSettings settings = rtgWorld.getGeneratorSettings();
            float duneHeight = this.minDuneHeight + (float)settings.sandDuneHeight;
            float stPitch = 200.0f;
            float stFactor = duneHeight *= (1.0f + rtgWorld.simplexInstance(2).noise2f((float)x / 330.0f, (float)y / 330.0f)) / 2.0f;
            float hPitch = 70.0f;
            float hDivisor = 40.0f;
            return TerrainBCOilDesert.terrainPolar(x, y, rtgWorld, river, stPitch, stFactor, hPitch, hDivisor, this.base) + TerrainBCOilDesert.groundNoise(x, y, 1.0f, rtgWorld);
        }
    }
}

