/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesyougo;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.BlockUtil;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightVariation;
import rtg.api.world.terrain.heighteffect.HillockEffect;
import rtg.world.biome.realistic.biomesyougo.RealisticBiomeBYGBase;

public class RealisticBiomeBYGBog
extends RealisticBiomeBYGBase {
    public RealisticBiomeBYGBog(Biome biome) {
        super(biome, RealisticBiomeBase.RiverType.NORMAL, RealisticBiomeBase.BeachType.NORMAL);
    }

    @Override
    public void initConfig() {
        this.getConfig().addProperty(this.getConfig().ALLOW_LOGS).set(true);
        this.getConfig().addProperty(this.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER);
    }

    @Override
    public void initDecos() {
        this.fallenTrees(new IBlockState[]{BlockUtil.getStateLog(BlockPlanks.EnumType.BIRCH), BlockUtil.getStateLog(BlockPlanks.EnumType.DARK_OAK)}, new int[]{2, 2});
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBYGBiome();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBYGBiome(this.getConfig(), this.baseBiome().field_76752_A, this.baseBiome().field_76753_B);
    }

    public static class SurfaceBYGBiome
    extends SurfaceBase {
        public SurfaceBYGBiome(BiomeConfig config, IBlockState top, IBlockState filler) {
            super(config, top, filler);
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBYGBiome
    extends TerrainBase {
        private final float bottom = 62.0f;
        private final HeightVariation bottomVariation = new HeightVariation();
        private final HillockEffect smallHills;
        private final HillockEffect mediumHills;

        public TerrainBYGBiome() {
            this.bottomVariation.height = 2.0f;
            this.bottomVariation.octave = 0;
            this.bottomVariation.wavelength = 40.0f;
            this.smallHills = new HillockEffect();
            this.smallHills.height = 5.0f;
            this.smallHills.wavelength = 25.0f;
            this.smallHills.minimumSimplex = 0.2f;
            this.smallHills.octave = 1;
            this.mediumHills = new HillockEffect();
            this.mediumHills.height = 10.0f;
            this.mediumHills.wavelength = 40.0f;
            this.mediumHills.minimumSimplex = 0.2f;
            this.mediumHills.octave = 2;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            float increment = this.bottomVariation.added(rtgWorld, x, y) + this.smallHills.added(rtgWorld, x, y);
            return TerrainBYGBiome.riverized(62.0f + (increment += this.mediumHills.added(rtgWorld, x, y)), river);
        }
    }
}

