/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPChaparral
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.chaparral.orNull();
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeBOPChaparral() {
        super(biome);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPChaparral();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPChaparral(this.getConfig(), RealisticBiomeBOPChaparral.biome.field_76752_A, RealisticBiomeBOPChaparral.biome.field_76753_B, Blocks.field_150354_m.func_176223_P(), 26.0f, 0.35f);
    }

    public static class SurfaceBOPChaparral
    extends SurfaceBase {
        private IBlockState mixBlock;
        private float width;
        private float height;

        public SurfaceBOPChaparral(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mix, float mixWidth, float mixHeight) {
            super(config, top, filler);
            this.mixBlock = mix;
            this.width = mixWidth;
            this.height = mixHeight;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.width, (float)j / this.width) > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPChaparral
    extends TerrainBase {
        private float baseHeight = 76.0f;
        private float peakyHillWavelength = 40.0f;
        private float peakyHillStrength = 40.0f;
        private float smoothHillWavelength = 60.0f;
        private float smoothHillStrength = 30.0f;
        private float wavelength = 10.0f;
        private float amplitude = 2.0f;

        public TerrainBOPChaparral() {
        }

        public TerrainBOPChaparral(float bh, float hs) {
            this.baseHeight = bh;
            this.peakyHillStrength = hs;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            this.groundNoise = TerrainBOPChaparral.groundNoise(x, y, this.groundNoiseAmplitudeHills, rtgWorld);
            ISimplexData2D jitterData = SimplexData2D.newDerivative();
            rtgWorld.simplexInstance(1).multiEval2D((float)x / this.wavelength, (float)y / this.wavelength, jitterData);
            int pX = (int)Math.round((double)x + jitterData.getDeltaX() * (double)this.amplitude);
            int pY = (int)Math.round((double)y + jitterData.getDeltaY() * (double)this.amplitude);
            float h = TerrainBOPChaparral.terrainGrasslandHills(pX, pY, rtgWorld, river, this.peakyHillWavelength, this.peakyHillStrength, this.smoothHillWavelength, this.smoothHillStrength, this.baseHeight);
            return this.groundNoise * river + h;
        }
    }
}

