/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature.tree.rtg;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import rtg.RTGConfig;
import rtg.api.world.gen.feature.tree.rtg.TreeRTG;

public class TreeRTGSalixMyrtilloides
extends TreeRTG {
    protected IBlockState trunkLog;

    public TreeRTGSalixMyrtilloides() {
        this.setLogBlock(Blocks.field_150364_r.func_176223_P()).setLeavesBlock(Blocks.field_150362_t.func_176223_P());
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!this.isGroundValid(world, pos, RTGConfig.treesCanGenerateOnSand())) {
            return false;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        this.trunkLog = this.getTrunkLog(this.logBlock);
        int height = 13;
        int leaveheight = 5;
        int branches = 6;
        int branchLenght = 6;
        for (int i = 0; i < height; ++i) {
            this.placeLogBlock(world, new BlockPos(x, y + i, z), this.logBlock, this.generateFlag);
        }
        this.createLeavesAroundBranch(world, rand, x, y + height, z, 3, 2);
        this.createTrunk(world, rand, x, y, z);
        int dir = rand.nextInt((int)(360.0f / (float)branches));
        for (int b = 0; b < branches; ++b) {
            float c = 0.0f;
            float hd = (float)height - rand.nextFloat() * (float)leaveheight - 2.0f;
            float xd = (float)Math.cos((double)(dir += (int)(360.0f / (float)branches)) * Math.PI / 180.0);
            float yd = (float)Math.sin((double)dir * Math.PI / 180.0);
            boolean m = false;
            while (c < (float)branchLenght) {
                if (c > (float)(branchLenght / 2) && !m) {
                    m = true;
                    this.createLeavesAroundBranch(world, rand, x + (int)(c * xd), y + (int)hd, z + (int)(c * yd), 2, 1);
                }
                this.placeLogBlock(world, new BlockPos(x + (int)((c += 1.0f) * xd), y + (int)(hd += 0.5f), z + (int)(c * yd)), this.trunkLog, this.generateFlag);
            }
            this.createLeavesAroundBranch(world, rand, x + (int)(c * xd), y + (int)hd, z + (int)(c * yd), 2, 1);
        }
        return true;
    }

    private void createLeavesAroundBranch(World world, Random rand, int x, int y, int z, int s, int c) {
        int t = (int)Math.pow(s, 2.0);
        for (int i = -s; i <= s; ++i) {
            for (int j = -s; j <= s; ++j) {
                for (int k = -s; k <= s; ++k) {
                    int l = i * i + j * j + k * k;
                    if (l > t || l >= t - c && !rand.nextBoolean() || this.noLeaves) continue;
                    this.placeLeavesBlock(world, new BlockPos(x + i, y + j, z + k), this.leavesBlock, this.generateFlag);
                    if (j >= -(s - 2) || rand.nextInt(3) == 0) continue;
                    this.createVine(world, rand, x + i, y + j, z + k);
                }
            }
        }
    }

    private void createVine(World world, Random rand, int x, int y, int z) {
        int r = rand.nextInt(3) + 5;
        for (int i = -1; i > -r; --i) {
            this.placeLeavesBlock(world, new BlockPos(x, y + i, z), this.leavesBlock, this.generateFlag);
        }
    }

    private void createTrunk(World world, Random rand, int x, int y, int z) {
        int[] pos = new int[]{0, 0, 1, 0, 0, 1, -1, 0, 0, -1};
        for (int t = 0; t < 5; ++t) {
            for (int sh = rand.nextInt(3) + y; sh > y - 3; --sh) {
                this.placeLogBlock(world, new BlockPos(x + pos[t * 2], sh, z + pos[t * 2 + 1]), this.trunkLog, this.generateFlag);
            }
        }
    }

    @Override
    protected boolean isGroundValid(World world, BlockPos trunkPos, boolean sandAllowed) {
        int x = trunkPos.func_177958_n();
        int y = trunkPos.func_177956_o();
        int z = trunkPos.func_177952_p();
        boolean earth = false;
        boolean water = false;
        for (int c1 = -2; c1 <= 2; ++c1) {
            for (int c3 = -2; c3 <= 2; ++c3) {
                for (int c2 = -1; c2 <= 1; ++c2) {
                    BlockPos posTemp = new BlockPos(x + c1, y + c2, z + c3);
                    IBlockState cb = world.func_180495_p(posTemp);
                    if (this.validGroundBlocks.contains(cb)) {
                        earth = true;
                        continue;
                    }
                    if (cb != Blocks.field_150355_j.func_176223_P()) continue;
                    water = true;
                }
            }
        }
        return earth && water;
    }
}

