/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.WorldGenSponge;

public class DecoSponge
extends DecoBase {
    protected ArrayList<Block> validGroundBlocks;
    private IBlockState spongeBlock;
    private float strengthFactor;
    private int minY;
    private int maxY;
    private HeightType heightType;
    private int chance;
    private boolean water;

    public DecoSponge() {
        this.setSpongeBlock(Blocks.field_150360_v.func_176223_P().func_177226_a((IProperty)BlockSponge.field_176313_a, (Comparable)Boolean.valueOf(true)));
        this.setStrengthFactor(2.0f);
        this.setMinY(20);
        this.setMaxY(45);
        this.setHeightType(HeightType.NEXT_INT);
        this.setChance(10);
        this.water = true;
        this.validGroundBlocks = new ArrayList<Block>(Arrays.asList(Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150351_n, Blocks.field_150435_aG, Blocks.field_150354_m));
        this.addDecoTypes(DecoBase.DecoType.SPONGE);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        int i = 0;
        while ((float)i < this.strengthFactor) {
            int y;
            BlockPos pos = DecoSponge.getOffsetPos(chunkPos).func_177982_a(rand.nextInt(16), 0, rand.nextInt(16));
            switch (this.heightType) {
                case NEXT_INT: {
                    y = DecoSponge.getRangedRandom(rand, this.minY, this.maxY);
                    break;
                }
                case GET_HEIGHT_VALUE: {
                    y = rtgWorld.world().func_175645_m(pos).func_177956_o();
                    break;
                }
                default: {
                    y = rtgWorld.world().func_175645_m(pos).func_177956_o();
                }
            }
            if (y >= this.minY && y <= this.maxY && rand.nextInt(this.chance) == 0) {
                new WorldGenSponge(this.spongeBlock, 0, rand, this.validGroundBlocks).func_180709_b(rtgWorld.world(), rand, pos.func_177981_b(y));
            }
            ++i;
        }
    }

    public IBlockState getSpongeBlock() {
        return this.spongeBlock;
    }

    public DecoSponge setSpongeBlock(IBlockState spongeBlock) {
        this.spongeBlock = spongeBlock;
        return this;
    }

    public float getStrengthFactor() {
        return this.strengthFactor;
    }

    public DecoSponge setStrengthFactor(float strengthFactor) {
        this.strengthFactor = strengthFactor;
        return this;
    }

    public int getMinY() {
        return this.minY;
    }

    public DecoSponge setMinY(int minY) {
        this.minY = minY;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoSponge setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public int getChance() {
        return this.chance;
    }

    public DecoSponge setChance(int chance) {
        this.chance = chance;
        return this;
    }

    public boolean isWater() {
        return this.water;
    }

    public DecoSponge setWater(boolean water) {
        this.water = water;
        return this;
    }

    public HeightType getHeightType() {
        return this.heightType;
    }

    public DecoSponge setHeightType(HeightType heightType) {
        this.heightType = heightType;
        return this;
    }

    public ArrayList<Block> getValidGroundBlocks() {
        return this.validGroundBlocks;
    }

    public DecoSponge setValidGroundBlocks(ArrayList<Block> validGroundBlocks) {
        this.validGroundBlocks = validGroundBlocks;
        return this;
    }

    public static enum HeightType {
        NEXT_INT,
        GET_HEIGHT_VALUE;

    }
}

