/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.deco;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import rtg.api.util.BlockUtil;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.IRealisticBiome;
import rtg.api.world.deco.DecoBase;
import rtg.api.world.gen.feature.WorldGenLog;

public class DecoFallenTree
extends DecoBase {
    private int loops;
    private Distribution distribution;
    private LogCondition logCondition;
    private float logConditionNoise;
    private int logConditionChance;
    private int maxY;
    private IBlockState logBlock;
    private IBlockState leavesBlock;
    private int minSize;
    private int maxSize;
    private IBlockState[] randomLogBlocks;

    public DecoFallenTree() {
        this.setLoops(1);
        this.setDistribution(new Distribution(100.0f, 5.0f, 0.8f));
        this.setLogCondition(LogCondition.RANDOM_CHANCE);
        this.setLogConditionChance(1);
        this.setMaxY(80);
        this.setLogBlock(Blocks.field_150364_r.func_176223_P());
        this.setLeavesBlock(Blocks.field_150362_t.func_176223_P());
        this.setMinSize(2);
        this.setMaxSize(4);
        this.randomLogBlocks = new IBlockState[0];
        this.addDecoTypes(DecoBase.DecoType.FALLEN_TREE);
    }

    @Override
    public void generate(IRealisticBiome biome, RTGWorld rtgWorld, Random rand, ChunkPos chunkPos, float river, boolean hasVillage) {
        BlockPos offsetpos = DecoFallenTree.getOffsetPos(chunkPos);
        if (this.randomLogBlocks.length > 0) {
            this.setLogBlock(this.randomLogBlocks[rand.nextInt(this.randomLogBlocks.length)]);
        }
        this.setLogConditionChance(this.adjustChanceFromMultiplier(this.getLogConditionChance(), biome.getConfig().FALLEN_LOG_DENSITY_MULTIPLIER.get()));
        int finalSize = this.maxSize > this.minSize ? DecoFallenTree.getRangedRandom(rand, this.minSize, this.maxSize) : (this.maxSize == this.minSize ? this.minSize : 4);
        for (int i = 0; i < this.loops; ++i) {
            if (!this.isValidLogCondition(rand)) continue;
            BlockPos pos = offsetpos.func_177982_a(rand.nextInt(16), 0, rand.nextInt(16));
            if ((pos = pos.func_177981_b(rtgWorld.world().func_175645_m(pos).func_177956_o())).func_177956_o() > this.maxY) continue;
            if (hasVillage && !BlockUtil.checkAreaBlocks(BlockUtil.MatchType.ALL_IGNORE_REPLACEABLE, rtgWorld.world(), pos, finalSize, new Block[0])) {
                return;
            }
            new WorldGenLog(this.logBlock, this.leavesBlock, finalSize).func_180709_b(rtgWorld.world(), rand, pos);
        }
    }

    public boolean isValidLogCondition(Random rand) {
        switch (this.logCondition) {
            case ALWAYS_GENERATE: {
                return true;
            }
            case RANDOM_CHANCE: {
                return rand.nextInt(this.logConditionChance) == 0;
            }
        }
        return false;
    }

    public int getLoops() {
        return this.loops;
    }

    public DecoFallenTree setLoops(int loops) {
        this.loops = loops;
        return this;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public DecoFallenTree setDistribution(Distribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public LogCondition getLogCondition() {
        return this.logCondition;
    }

    public DecoFallenTree setLogCondition(LogCondition logCondition) {
        this.logCondition = logCondition;
        return this;
    }

    public float getLogConditionNoise() {
        return this.logConditionNoise;
    }

    public int getLogConditionChance() {
        return this.logConditionChance;
    }

    public DecoFallenTree setLogConditionChance(int logConditionChance) {
        this.logConditionChance = logConditionChance;
        return this;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public DecoFallenTree setMaxY(int maxY) {
        this.maxY = maxY;
        return this;
    }

    public IBlockState getLogBlock() {
        return this.logBlock;
    }

    public DecoFallenTree setLogBlock(IBlockState logBlock) {
        this.logBlock = logBlock;
        return this;
    }

    public IBlockState getLeavesBlock() {
        return this.leavesBlock;
    }

    public DecoFallenTree setLeavesBlock(IBlockState leavesBlock) {
        this.leavesBlock = leavesBlock;
        return this;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public DecoFallenTree setMinSize(int minSize) {
        this.minSize = minSize;
        return this;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public DecoFallenTree setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public IBlockState[] getRandomLogBlocks() {
        return this.randomLogBlocks;
    }

    public DecoFallenTree setRandomLogBlocks(IBlockState[] randomLogBlocks) {
        this.randomLogBlocks = randomLogBlocks;
        return this;
    }

    private int adjustChanceFromMultiplier(int chanceIn, float multiplier) {
        int chanceOut = multiplier != 0.0f ? (int)Math.floor((float)chanceIn / multiplier) : chanceIn;
        return chanceOut == 0 ? 1 : chanceOut;
    }

    public static class Distribution {
        private float noiseDivisor;
        private float noiseFactor;
        private float noiseAddend;

        public Distribution(float noiseDivisor, float noiseFactor, float noiseAddend) {
            this.noiseDivisor = noiseDivisor;
            this.noiseFactor = noiseFactor;
            this.noiseAddend = noiseAddend;
        }

        public float getNoiseDivisor() {
            return this.noiseDivisor;
        }

        public Distribution setNoiseDivisor(float noiseDivisor) {
            this.noiseDivisor = noiseDivisor;
            return this;
        }

        public float getNoiseFactor() {
            return this.noiseFactor;
        }

        public Distribution setNoiseFactor(float noiseFactor) {
            this.noiseFactor = noiseFactor;
            return this;
        }

        public float getNoiseAddend() {
            return this.noiseAddend;
        }

        public Distribution setNoiseAddend(float noiseAddend) {
            this.noiseAddend = noiseAddend;
            return this;
        }
    }

    public static enum LogCondition {
        ALWAYS_GENERATE,
        RANDOM_CHANCE;

    }
}

