/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util.noise;

import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.OpenSimplexNoise;

public abstract class SimplexData2D
implements ISimplexData2D {
    private double deltaX;
    private double deltaY;

    private SimplexData2D() {
        this.clear();
    }

    public static ISimplexData2D newDisk() {
        return new Disk();
    }

    public static ISimplexData2D newDerivative() {
        return new Derivative();
    }

    @Override
    public final double getDeltaX() {
        return this.deltaX;
    }

    @Override
    public final void setDeltaX(double deltaX) {
        this.deltaX = deltaX;
    }

    @Override
    public final double getDeltaY() {
        return this.deltaY;
    }

    @Override
    public final void setDeltaY(double deltaY) {
        this.deltaY = deltaY;
    }

    @Override
    public final void addToDeltaX(double val) {
        this.deltaX += val;
    }

    @Override
    public final void addToDeltaY(double val) {
        this.deltaY += val;
    }

    @Override
    public final void clear() {
        this.setDeltaX(0.0);
        this.setDeltaY(0.0);
    }

    public static final class Derivative
    extends SimplexData2D
    implements ISimplexData2D {
        private Derivative() {
        }

        @Override
        public ISimplexData2D.DataRequest request() {
            return (attn, extrapolation, gx, gy, gi_sph2, dx, dy) -> {
                double attnSq = Math.pow(attn, 2.0);
                this.addToDeltaX((gx * attn - 8.0 * dx * extrapolation) * attnSq * attn);
                this.addToDeltaY((gy * attn - 8.0 * dy * extrapolation) * attnSq * attn);
            };
        }
    }

    public static final class Disk
    extends SimplexData2D
    implements ISimplexData2D {
        private Disk() {
        }

        @Override
        public ISimplexData2D.DataRequest request() {
            return (attn, extrapolation, gx, gy, gi_sph2, dx, dy) -> {
                double attnSq = Math.pow(attn, 2.0);
                double extrap = Math.pow(attnSq, 2.0) * extrapolation;
                this.addToDeltaX(extrap * OpenSimplexNoise.GRADIENTS_SPH2[gi_sph2]);
                this.addToDeltaY(extrap * OpenSimplexNoise.GRADIENTS_SPH2[gi_sph2 + 1]);
            };
        }
    }
}

