/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.forces;

import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adhooks.forces.ForceTarget;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Deprecated
public class ForceController {
    protected static final Map<Entity, ForceTarget> serverTargets = new ConcurrentHashMap<Entity, ForceTarget>();
    protected static final Map<Entity, ForceTarget> clientTargets = new ConcurrentHashMap<Entity, ForceTarget>();

    public static Optional<ForceTarget> getTarget(Entity entity) {
        return Optional.ofNullable(ForceController.findTarget(entity));
    }

    public static ForceTarget getOrCreateTarget(Entity entity) {
        ForceTarget target = ForceController.findTarget(entity);
        if (target == null) {
            target = ForceController.createTarget(entity);
        }
        return target;
    }

    protected static ForceTarget createTarget(Entity entity) {
        ForceTarget target = new ForceTarget(entity);
        if (ForgeEntity.isServerSide((Entity)entity)) {
            serverTargets.put(entity, target);
        } else {
            clientTargets.put(entity, target);
        }
        return target;
    }

    @Nullable
    protected static ForceTarget findTarget(Entity entity) {
        if (ForgeEntity.isServerSide((Entity)entity)) {
            return serverTargets.get(entity);
        }
        return clientTargets.get(entity);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        Collection<ForceTarget> targets = serverTargets.values();
        if (event.phase == TickEvent.Phase.END) {
            ForceController.applyTo(targets);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Collection<ForceTarget> targets = clientTargets.values();
        if (event.phase == TickEvent.Phase.END) {
            ForceController.applyTo(targets);
        }
    }

    protected static void applyTo(Collection<ForceTarget> targets) {
        Iterator<ForceTarget> iterator = targets.iterator();
        while (iterator.hasNext()) {
            ForceTarget target = iterator.next();
            if (target.exist()) {
                target.applyForces();
                continue;
            }
            iterator.remove();
        }
    }
}

