/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.storage;

import betterquesting.api.properties.IPropertyContainer;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api2.storage.INBTSaveLoad;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class PropertyContainer
implements IPropertyContainer,
INBTSaveLoad<NBTTagCompound> {
    private final NBTTagCompound nbtInfo = new NBTTagCompound();

    @Override
    public synchronized <T> T getProperty(IPropertyType<T> prop) {
        if (prop == null) {
            return null;
        }
        return this.getProperty(prop, prop.getDefault());
    }

    @Override
    public synchronized <T> T getProperty(IPropertyType<T> prop, T def) {
        if (prop == null) {
            return def;
        }
        NBTTagCompound jProp = this.getDomain(prop.getKey());
        if (!jProp.func_74764_b(prop.getKey().func_110623_a())) {
            return def;
        }
        return prop.readValue(jProp.func_74781_a(prop.getKey().func_110623_a()));
    }

    @Override
    public synchronized boolean hasProperty(IPropertyType<?> prop) {
        if (prop == null) {
            return false;
        }
        return this.getDomain(prop.getKey()).func_74764_b(prop.getKey().func_110623_a());
    }

    @Override
    public synchronized void removeProperty(IPropertyType<?> prop) {
        if (prop == null) {
            return;
        }
        NBTTagCompound jProp = this.getDomain(prop.getKey());
        if (!jProp.func_74764_b(prop.getKey().func_110623_a())) {
            return;
        }
        jProp.func_82580_o(prop.getKey().func_110623_a());
        if (jProp.func_82582_d()) {
            this.nbtInfo.func_82580_o(prop.getKey().func_110624_b());
        }
    }

    @Override
    public synchronized <T> void setProperty(IPropertyType<T> prop, T value) {
        if (prop == null || value == null) {
            return;
        }
        NBTTagCompound dom = this.getDomain(prop.getKey());
        dom.func_74782_a(prop.getKey().func_110623_a(), prop.writeValue(value));
        this.nbtInfo.func_74782_a(prop.getKey().func_110624_b(), (NBTBase)dom);
    }

    @Override
    public synchronized void removeAllProps() {
        ArrayList keys = new ArrayList(this.nbtInfo.func_150296_c());
        for (String key : keys) {
            this.nbtInfo.func_82580_o(key);
        }
    }

    @Override
    public synchronized NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_179237_a(this.nbtInfo);
        return nbt;
    }

    @Override
    public synchronized void readFromNBT(NBTTagCompound nbt) {
        for (String key : this.nbtInfo.func_150296_c()) {
            this.nbtInfo.func_82580_o(key);
        }
        this.nbtInfo.func_179237_a(nbt);
    }

    private NBTTagCompound getDomain(ResourceLocation res) {
        return this.nbtInfo.func_74775_l(res.func_110624_b());
    }
}

