/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels;

import betterquesting.api.utils.RenderUtils;
import betterquesting.api2.client.gui.misc.ComparatorGuiDepth;
import betterquesting.api2.client.gui.misc.GuiRectLerp;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiCanvas;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;

public class CanvasResizeable
implements IGuiCanvas {
    private final List<IGuiPanel> guiPanels = new CopyOnWriteArrayList<IGuiPanel>();
    private IGuiTexture bgTexture;
    private final GuiRectLerp rectLerp;
    private boolean enabled = true;
    private final boolean crop;

    public CanvasResizeable(IGuiRect rect, IGuiTexture texture) {
        this(rect, texture, true);
    }

    public CanvasResizeable(IGuiRect rect, IGuiTexture texture, boolean crop) {
        this.bgTexture = texture;
        this.rectLerp = new GuiRectLerp(rect);
        this.crop = crop;
    }

    public void changeBG(@Nullable IGuiTexture texture) {
        this.bgTexture = texture;
    }

    @Override
    public IGuiRect getTransform() {
        return this.crop ? this.rectLerp.getProxyRect() : this.rectLerp;
    }

    public GuiRectLerp getRectLerp() {
        return this.rectLerp;
    }

    @Override
    @Nonnull
    public List<IGuiPanel> getChildren() {
        return this.guiPanels;
    }

    @Override
    public void initPanel() {
        this.guiPanels.clear();
    }

    @Override
    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void lerpToRect(@Nonnull IGuiRect rect, long time, boolean inheritParent) {
        if (inheritParent) {
            rect.setParent(this.rectLerp.getParent());
        }
        this.rectLerp.lerpTo(rect, time);
    }

    public void snapToRect(@Nonnull IGuiRect rect, boolean inheritParent) {
        if (inheritParent) {
            rect.setParent(this.rectLerp.getParent());
        }
        this.rectLerp.snapTo(rect);
    }

    @Override
    public void drawPanel(int mx, int my, float partialTick) {
        if (this.crop) {
            RenderUtils.startScissor(this.rectLerp);
        }
        if (this.bgTexture != null) {
            GuiRectLerp bounds = this.rectLerp;
            GlStateManager.func_179094_E();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.bgTexture.drawTexture(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight(), 0.0f, partialTick);
            GlStateManager.func_179121_F();
        }
        for (IGuiPanel entry : this.guiPanels) {
            if (!entry.isEnabled()) continue;
            entry.drawPanel(mx, my, partialTick);
        }
        if (this.crop) {
            RenderUtils.endScissor();
        }
    }

    @Override
    public boolean onMouseClick(int mx, int my, int click) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseClick(mx, my, click)) continue;
            used = true;
            break;
        }
        return used || this.bgTexture != null && this.rectLerp.contains(mx, my);
    }

    @Override
    public boolean onMouseRelease(int mx, int my, int click) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseRelease(mx, my, click)) continue;
            used = true;
            break;
        }
        return used || this.bgTexture != null && this.rectLerp.contains(mx, my);
    }

    @Override
    public boolean onMouseScroll(int mx, int my, int scroll) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onMouseScroll(mx, my, scroll)) continue;
            used = true;
            break;
        }
        return used || this.bgTexture != null && this.rectLerp.contains(mx, my);
    }

    @Override
    public boolean onKeyTyped(char c, int keycode) {
        boolean used = false;
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || !entry.onKeyTyped(c, keycode)) continue;
            used = true;
            break;
        }
        return used;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        ListIterator<IGuiPanel> pnIter = this.guiPanels.listIterator(this.guiPanels.size());
        while (pnIter.hasPrevious()) {
            List<String> tt;
            IGuiPanel entry = pnIter.previous();
            if (!entry.isEnabled() || (tt = entry.getTooltip(mx, my)) == null) continue;
            return tt;
        }
        return this.bgTexture != null && this.rectLerp.contains(mx, my) ? Collections.emptyList() : null;
    }

    @Override
    public void addPanel(IGuiPanel panel) {
        if (panel == null || this.guiPanels.contains(panel)) {
            return;
        }
        this.guiPanels.add(panel);
        this.guiPanels.sort(ComparatorGuiDepth.INSTANCE);
        panel.getTransform().setParent(this.getTransform());
        panel.initPanel();
    }

    @Override
    public boolean removePanel(IGuiPanel panel) {
        return this.guiPanels.remove(panel);
    }

    @Override
    public void resetCanvas() {
        this.guiPanels.clear();
    }
}

