/*
 * Decompiled with CFR 0.152.
 */
package levelup2.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import levelup2.api.IPlayerSkill;
import levelup2.skills.SkillRegistry;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class SkillProperties {
    private String skillName;
    private int[] levels;
    private String[] prerequisites;
    private int column;
    private int row;
    private boolean enabled;
    private boolean active;

    public static SkillProperties fromJson(String skillName, JsonObject obj) {
        int[] levels = SkillProperties.getLevels(obj);
        String[] prerequisites = SkillProperties.getPrerequisites(obj);
        int column = JsonUtils.func_151208_a((JsonObject)obj, (String)"column", (int)0);
        int row = JsonUtils.func_151208_a((JsonObject)obj, (String)"row", (int)0);
        boolean enabled = JsonUtils.func_151209_a((JsonObject)obj, (String)"enabled", (boolean)true);
        boolean active = JsonUtils.func_151209_a((JsonObject)obj, (String)"active", (boolean)true);
        return new SkillProperties(skillName, levels, prerequisites, column, row, enabled, active);
    }

    public SkillProperties(String skillName, int[] levelCosts, String[] prerequisites, int column, int row, boolean enabled, boolean active) {
        this.skillName = skillName;
        this.levels = levelCosts;
        this.prerequisites = prerequisites;
        this.column = column;
        this.row = row;
        this.enabled = enabled;
        this.active = active;
    }

    public int[] getLevels() {
        return this.levels;
    }

    public String[] getPrerequisites() {
        return this.prerequisites;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public void writeToBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("name", this.skillName);
        if (this.getLevels() != null && this.getLevels().length > 0) {
            tag.func_74783_a("levels", this.getLevels());
        }
        NBTTagCompound prereqs = new NBTTagCompound();
        if (this.getPrerequisites() != null && this.getPrerequisites().length > 0) {
            for (int i = 0; i < this.getPrerequisites().length; ++i) {
                String prereq = this.getPrerequisites()[i];
                prereqs.func_74778_a("prereq_" + i, prereq);
            }
            tag.func_74782_a("prereqs", (NBTBase)prereqs);
        }
        tag.func_74768_a("column", this.getColumn());
        tag.func_74768_a("row", this.getRow());
        tag.func_74757_a("enabled", this.isEnabled());
        tag.func_74757_a("active", this.isActive());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static void fromNBT(NBTTagCompound tag) {
        IPlayerSkill skill = SkillRegistry.getSkillFromName(tag.func_74779_i("name"));
        if (skill != null && skill.hasExternalJson()) {
            if (tag.func_74764_b("levels")) {
                skill.setLevelCosts(tag.func_74759_k("levels"));
            } else {
                skill.setLevelCosts(new int[0]);
            }
            if (tag.func_74764_b("prereqs")) {
                NBTTagCompound t = tag.func_74775_l("prereqs");
                int i = 0;
                ArrayList<String> prereqs = new ArrayList<String>();
                while (t.func_74764_b("prereq_" + i)) {
                    prereqs.add(t.func_74779_i("prereq_" + i));
                    ++i;
                }
                String[] str = new String[prereqs.size()];
                for (int j = 0; j < str.length; ++j) {
                    str[j] = (String)prereqs.get(j);
                }
                skill.setPrerequisites(str);
            } else {
                skill.setPrerequisites(new String[0]);
            }
            skill.setSkillColumn(tag.func_74762_e("column"));
            skill.setSkillRow(tag.func_74762_e("row"));
            skill.setEnabled(tag.func_74767_n("enabled"));
            skill.setActive(tag.func_74767_n("active"));
        }
    }

    private static int[] getLevels(JsonObject obj) {
        JsonArray levels = JsonUtils.func_151213_a((JsonObject)obj, (String)"levels", null);
        if (levels != null) {
            ArrayList<Integer> lvl = new ArrayList<Integer>();
            for (JsonElement element : levels) {
                lvl.add(element.getAsInt());
            }
            int[] lvls = new int[lvl.size()];
            for (int i = 0; i < lvls.length; ++i) {
                lvls[i] = (Integer)lvl.get(i);
            }
            return lvls;
        }
        return new int[0];
    }

    private static String[] getPrerequisites(JsonObject obj) {
        JsonArray prereqs = JsonUtils.func_151213_a((JsonObject)obj, (String)"prerequisites", null);
        if (prereqs != null) {
            ArrayList<String> prereq = new ArrayList<String>();
            for (JsonElement element : prereqs) {
                prereq.add(element.getAsString());
            }
            String[] str = new String[prereq.size()];
            for (int i = 0; i < str.length; ++i) {
                str[i] = (String)prereq.get(i);
            }
            return str;
        }
        return new String[0];
    }
}

