/*
 * Decompiled with CFR 0.152.
 */
package levelup2.skills.crafting;

import levelup2.skills.BaseSkill;
import levelup2.skills.SkillRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class FoodGrowthBonus
extends BaseSkill {
    @Override
    public String getSkillName() {
        return "levelup:cropgrowth";
    }

    @Override
    public byte getSkillType() {
        return 1;
    }

    @Override
    public ItemStack getRepresentativeStack() {
        return new ItemStack(Items.field_151019_K);
    }

    @Override
    public boolean hasSubscription() {
        return true;
    }

    @SubscribeEvent
    public void onPlayerUpdate(TickEvent.PlayerTickEvent evt) {
        EntityPlayer player;
        if (!this.isActive()) {
            return;
        }
        if (evt.phase == TickEvent.Phase.START && (player = evt.player) != null) {
            int skillLevel = SkillRegistry.getSkillLevel(player, this.getSkillName());
            if (!player.field_70170_p.field_72995_K && skillLevel > 0 && player.func_70681_au().nextFloat() <= (float)skillLevel / 500.0f) {
                this.growCropsAround(player.field_70170_p, skillLevel, player);
            }
        }
    }

    private void growCropsAround(World world, int range, EntityPlayer player) {
        int posX = (int)player.field_70165_t;
        int posY = (int)player.field_70163_u;
        int posZ = (int)player.field_70161_v;
        int dist = range / 2 + 2;
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)new BlockPos(posX - dist, posY - dist, posZ - dist), (BlockPos)new BlockPos(posX + dist + 1, posY + dist + 1, posZ + dist + 1))) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!(block instanceof IPlantable) || SkillRegistry.getCropBlacklist().contains(block)) continue;
            world.func_175684_a(pos, block, block.func_149738_a(world));
        }
    }
}

