/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanhudbaubles.util;

import com.oblivioussp.spartanhudbaubles.client.gui.AlignmentHelper;
import com.oblivioussp.spartanhudbaubles.util.SkinType;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    private static final String VERSION = Integer.toString(1);
    private static Configuration config;
    private static final String[] VALID_ALIGNMENT_VALUES;
    private static final String[] VALID_SKIN_VALUES;
    public static boolean disableHUD;
    public static SkinType skinType;
    public static boolean showBaublesIcon;
    public static int tooltipBackgroundColour;
    public static int tooltipFrameTopColour;
    public static int tooltipFrameBottomColour;
    public static int minimalTopColour;
    public static int minimalBottomColour;
    public static AlignmentHelper.Alignment hudAlignment;
    public static int hudOffsetX;
    public static int hudOffsetY;
    public static boolean hudRotateVertical;

    public static void init(Path configPath) {
        File configFile = configPath.resolve("spartanhudbaubles".toLowerCase() + ".cfg").toFile();
        if (config == null) {
            config = new Configuration(configFile, VERSION);
            Config.load();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent ev) {
        if (ev.getModID().equalsIgnoreCase("spartanhudbaubles")) {
            Config.load();
        }
    }

    private static void load() {
        disableHUD = config.getBoolean("disable_hud", "client", false, "Set to true to disable the Baubles HUD Element (which essentially disables the entire mod)", "config.spartanhudbaubles:client.disable_hud");
        showBaublesIcon = config.getBoolean("show_baubles_icon", "client", true, "Enables display of the Baubles icon next to the Baubles HUD Element. This won't show if the skin type is set to 'None'", "config.spartanhudbaubles:client.show_baubles_icon");
        ColourValue tooltipBGColour = ColourValue.fromConfig(config, "tooltip_background_colour", "client", -267386864, "Background colour for the tooltip skin variant");
        tooltipBackgroundColour = tooltipBGColour.toInteger();
        ColourValue tooltipFrTopColour = ColourValue.fromConfig(config, "tooltip_frame_top_colour", "client", 0x505000FF, "Frame top colour for the tooltip skin variant");
        tooltipFrameTopColour = tooltipFrTopColour.toInteger();
        ColourValue tooltipFrBtmColour = ColourValue.fromConfig(config, "tooltip_frame_bottom_colour", "client", 1344798847, "Frame bottom colour for the tooltip skin variant");
        tooltipFrameBottomColour = tooltipFrBtmColour.toInteger();
        ColourValue minTopColour = ColourValue.fromConfig(config, "minimal_top_colour", "client", 0x202020, "Top colour for the minimal skin variant");
        minimalTopColour = minTopColour.toInteger();
        ColourValue minBtmColour = ColourValue.fromConfig(config, "minimal_bottom_colour", "client", -1071636448, "Bottom colour for the minimal skin variant");
        minimalBottomColour = minBtmColour.toInteger();
        String skinTypeString = config.getString("skin_type", "client", SkinType.HOTBAR_STYLE.toString(), "Skin variant to display behind the Baubles in the HUD Element", VALID_SKIN_VALUES, "config.spartanhudbaubles:client.skin_type");
        skinType = SkinType.valueOf(skinTypeString);
        String hudAlignmentString = config.getString("alignment", "client", AlignmentHelper.Alignment.BOTTOM_RIGHT.toString(), "Alignment of the Baubles HUD Element", VALID_ALIGNMENT_VALUES, "config.spartanhudbaubles:client.alignment");
        hudAlignment = AlignmentHelper.Alignment.valueOf(hudAlignmentString);
        hudOffsetX = config.getInt("offset_x", "client", 0, -1000, 1000, "X offset of the Baubles HUD Element. Can be used to adjust the X position", "config.spartanhudbaubles:client.offset_x");
        hudOffsetY = config.getInt("offset_y", "client", 0, -1000, 1000, "Y offset of the Baubles HUD Element. Can be used to adjust the Y position", "config.spartanhudbaubles:client.offset_y");
        hudRotateVertical = config.getBoolean("rotate_vertical", "client", false, "Set to true to rotate the Baubles HUD Element vertically or false for horizontally", "config.spartanhudbaubles:client.rotate_vertical");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static Configuration getConfig() {
        return config;
    }

    static {
        VALID_ALIGNMENT_VALUES = AlignmentHelper.Alignment.getValidConfigValues();
        VALID_SKIN_VALUES = SkinType.getValidConfigValues();
        disableHUD = false;
        showBaublesIcon = true;
        tooltipBackgroundColour = -267386864;
        tooltipFrameTopColour = 0x505000FF;
        tooltipFrameBottomColour = 1344798847;
        minimalTopColour = 0x202020;
        minimalBottomColour = -1071636448;
        hudRotateVertical = false;
    }

    public static class ColourValue {
        private byte r;
        private byte g;
        private byte b;
        private byte a;

        public static ColourValue fromConfig(Configuration config, String name, String category, int defaultValue, String comment) {
            ConfigCategory cfgCategory = config.getCategory(category + "." + name);
            cfgCategory.setComment(comment);
            cfgCategory.setLanguageKey("config.spartanhudbaubles:client." + name);
            String[] order = new String[]{"red", "green", "blue", "alpha"};
            cfgCategory.setPropertyOrder(Arrays.asList(order));
            byte alpha = (byte)config.getInt("alpha", cfgCategory.getQualifiedName(), defaultValue >> 24 & 0xFF, 0, 255, "");
            byte red = (byte)config.getInt("red", cfgCategory.getQualifiedName(), defaultValue >> 16 & 0xFF, 0, 255, "");
            byte green = (byte)config.getInt("green", cfgCategory.getQualifiedName(), defaultValue >> 8 & 0xFF, 0, 255, "");
            byte blue = (byte)config.getInt("blue", cfgCategory.getQualifiedName(), defaultValue & 0xFF, 0, 255, "");
            return new ColourValue(red, green, blue, alpha);
        }

        public ColourValue(byte r, byte g, byte b, byte a) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public int toInteger() {
            int value = ((this.a & 0xFF) << 24) + ((this.r & 0xFF) << 16) + ((this.g & 0xFF) << 8) + (this.b & 0xFF) & 0xFFFFFFFF;
            return value;
        }
    }
}

