/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.qualitytools.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.tmtravlr.qualitytools.QualityToolsHelper;
import com.tmtravlr.qualitytools.baubles.BaublesHandler;
import com.tmtravlr.qualitytools.config.ConfigLoader;
import java.lang.reflect.Type;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;

public class QualityItem {
    public String itemClass;
    public Item item;
    public String[] equipLocations;
    public int meta;
    public NBTTagCompound tag;

    public boolean itemMatches(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        if (this.meta != Short.MAX_VALUE && stack.func_77952_i() != this.meta) {
            return false;
        }
        if (this.tag != null && !NBTUtil.func_181123_a((NBTBase)this.tag, (NBTBase)stack.func_77978_p(), (boolean)true)) {
            return false;
        }
        if (this.item != null && stack.func_77973_b() != this.item) {
            return false;
        }
        if (this.itemClass != null && !QualityToolsHelper.hasClassType(this.itemClass, stack.func_77973_b().getClass())) {
            return false;
        }
        if (this.equipLocations != null && this.equipLocations.length > 0) {
            boolean canEquip = false;
            for (String location : this.equipLocations) {
                if (BaublesHandler.INSTANCE.canEquipBauble(stack, location)) {
                    canEquip = true;
                }
                try {
                    EntityEquipmentSlot equipment = EntityEquipmentSlot.func_188451_a((String)location);
                    if (stack.func_77973_b() instanceof ItemArmor && ((ItemArmor)stack.func_77973_b()).field_77881_a == equipment || equipment == EntityEquipmentSlot.CHEST && stack.func_77973_b() == Items.field_185160_cR) {
                        canEquip = true;
                        continue;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (!location.equalsIgnoreCase("horse") || HorseArmorType.func_188580_a((ItemStack)stack) == HorseArmorType.NONE) continue;
                canEquip = true;
            }
            if (!canEquip) {
                return false;
            }
        }
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<QualityItem> {
        public QualityItem deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            String tagString;
            JsonObject json = jsonElement.getAsJsonObject();
            QualityItem qualityItem = new QualityItem();
            qualityItem.meta = JsonUtils.func_151208_a((JsonObject)json, (String)"meta", (int)Short.MAX_VALUE);
            String string = tagString = json.has("tag") ? JsonUtils.func_151200_h((JsonObject)json, (String)"tag") : "";
            if (!tagString.isEmpty() && !tagString.equals("{}")) {
                try {
                    qualityItem.tag = JsonToNBT.func_180713_a((String)tagString);
                }
                catch (NBTException e) {
                    FMLLog.warning((String)"[Quality Tools] Problem loading item tag %s in %s. Ignoring.", (Object[])new Object[]{tagString, ConfigLoader.typeDeserializing});
                    ConfigLoader.problems.add(ConfigLoader.typeDeserializing + ": Problem loading nbt tag: " + e.getMessage() + ", with tag " + tagString);
                }
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"class")) {
                qualityItem.itemClass = JsonUtils.func_151200_h((JsonObject)json, (String)"class");
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"slot")) {
                if (JsonUtils.func_151205_a((JsonObject)json, (String)"slot")) {
                    qualityItem.equipLocations = new String[]{JsonUtils.func_151200_h((JsonObject)json, (String)"slot")};
                } else {
                    JsonArray slotArray = JsonUtils.func_151214_t((JsonObject)json, (String)"slot");
                    qualityItem.equipLocations = new String[slotArray.size()];
                    for (int i = 0; i < qualityItem.equipLocations.length; ++i) {
                        if (!slotArray.get(i).isJsonPrimitive() || !slotArray.get(i).getAsJsonPrimitive().isString()) {
                            throw new JsonSyntaxException("Expected slot entry to be a string, was " + JsonUtils.func_151222_d((JsonElement)slotArray.get(i)));
                        }
                        qualityItem.equipLocations[i] = slotArray.get(i).getAsString();
                    }
                }
            }
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"item")) {
                String itemName = JsonUtils.func_151200_h((JsonObject)json, (String)"item");
                qualityItem.item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(itemName));
                if (qualityItem.item == null) {
                    if (ConfigLoader.ignoreUnknownItems) {
                        FMLLog.warning((String)"[Quality Tools] Unknown item %s in %s. Ignoring.", (Object[])new Object[]{itemName, ConfigLoader.typeDeserializing});
                        return null;
                    }
                    throw new JsonParseException("Unknown item " + itemName);
                }
            }
            return qualityItem;
        }
    }
}

