/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.qualitytools;

import com.tmtravlr.qualitytools.QualityToolsHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="qualitytools")
public class ClientEventHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        NBTTagCompound tag = QualityToolsHelper.getQualityTag(event.getItemStack());
        if (!tag.func_82582_d()) {
            event.getToolTip().add("");
            TextFormatting color = TextFormatting.func_96300_b((String)tag.func_74779_i("Color"));
            event.getToolTip().add(TextFormatting.GRAY + I18n.func_135052_a((String)"info.quality.name", (Object[])new Object[0]) + (color == null ? "" : color) + I18n.func_135052_a((String)tag.func_74779_i("Name"), (Object[])new Object[0]));
            NBTTagList slotList = tag.func_150295_c("Slots", 8);
            for (int i = 0; i < slotList.func_74745_c(); ++i) {
                String slot = slotList.func_150307_f(i);
                event.getToolTip().add(TextFormatting.GRAY + I18n.func_135052_a((String)("item.modifiers." + slot.toLowerCase()), (Object[])new Object[0]));
            }
            NBTTagList attributeList = tag.func_150295_c("AttributeModifiers", 10);
            for (int i = 0; i < attributeList.func_74745_c(); ++i) {
                AttributeModifier modifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)attributeList.func_150305_b(i));
                String attributeName = attributeList.func_150305_b(i).func_74779_i("AttributeName");
                double amount = modifier.func_111164_d();
                double displayAmount = modifier.func_111169_c() != 1 && modifier.func_111169_c() != 2 ? amount : amount * 100.0;
                if (amount > 0.0) {
                    event.getToolTip().add(TextFormatting.BLUE + " " + I18n.func_135052_a((String)("attribute.modifier.plus." + modifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(displayAmount), I18n.func_135052_a((String)("attribute.name." + attributeName), (Object[])new Object[0])}));
                    continue;
                }
                if (!(amount < 0.0)) continue;
                event.getToolTip().add(TextFormatting.RED + " " + I18n.func_135052_a((String)("attribute.modifier.take." + modifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(displayAmount *= -1.0), I18n.func_135052_a((String)("attribute.name." + attributeName), (Object[])new Object[0])}));
            }
        }
    }
}

