/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.event;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import melonslise.locks.common.capability.ILockableWorldGenHandler;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="locks")
public class LocksDelayEvents {
    private static Map<Integer, Map<ChunkPos, ChunkDelay>> chunksToPoll = new ConcurrentHashMap<Integer, Map<ChunkPos, ChunkDelay>>();
    public static int delay = 20;

    private LocksDelayEvents() {
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        LocksDelayEvents.tryAddChunkToPoll(event.getChunkInstance());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.world.field_72995_K) {
            return;
        }
        LocksDelayEvents.pollChunksInWorld(event.world);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        LocksDelayEvents.clearDimensionInPollMap(event.getWorld());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        LocksDelayEvents.clearDimensionInPollMap(event.getWorld());
    }

    private static void tryAddChunkToPoll(Chunk c) {
        int dimension = c.func_177412_p().field_73011_w.getDimension();
        Map<ChunkPos, ChunkDelay> dimChunkMap = LocksDelayEvents.getChunksToPollMap(dimension);
        if (!dimChunkMap.containsKey(c.func_76632_l())) {
            dimChunkMap.put(c.func_76632_l(), new ChunkDelay(delay));
        }
    }

    private static void clearDimensionInPollMap(World world) {
        int dimension = world.field_73011_w.getDimension();
        Map<ChunkPos, ChunkDelay> dimChunkMap = LocksDelayEvents.getChunksToPollMap(dimension);
        dimChunkMap.clear();
    }

    private static void pollChunksInWorld(World world) {
        int dimension = world.field_73011_w.getDimension();
        Map<ChunkPos, ChunkDelay> dimChunkMap = LocksDelayEvents.getChunksToPollMap(dimension);
        Iterator<Map.Entry<ChunkPos, ChunkDelay>> it = dimChunkMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ChunkPos, ChunkDelay> entry = it.next();
            if (!entry.getValue().tick()) continue;
            ChunkPos cpos = entry.getKey();
            if (LocksUtil.hasChunk(world, cpos.field_77276_a, cpos.field_77275_b)) {
                if (LocksUtil.hasChunk(world, cpos.field_77276_a + 1, cpos.field_77275_b) && LocksUtil.hasChunk(world, cpos.field_77276_a - 1, cpos.field_77275_b) && LocksUtil.hasChunk(world, cpos.field_77276_a, cpos.field_77275_b - 1) && LocksUtil.hasChunk(world, cpos.field_77276_a, cpos.field_77275_b + 1)) {
                    ((ILockableWorldGenHandler)world.func_72964_e(cpos.field_77276_a, cpos.field_77275_b).getCapability(LocksCapabilities.LOCKABLE_WORLDGEN_HANDLER, null)).tryGeneratingLocks();
                    it.remove();
                    continue;
                }
                entry.getValue().reset();
                continue;
            }
            it.remove();
        }
    }

    @Nonnull
    private static Map<ChunkPos, ChunkDelay> getChunksToPollMap(int dimension) {
        Map<ChunkPos, ChunkDelay> dimChunkMap = chunksToPoll.get(dimension);
        if (dimChunkMap == null) {
            dimChunkMap = new ConcurrentHashMap<ChunkPos, ChunkDelay>();
            chunksToPoll.put(dimension, dimChunkMap);
        }
        return dimChunkMap;
    }

    private static class ChunkDelay {
        private int delay;

        public ChunkDelay(int delay) {
            this.delay = delay;
        }

        public boolean tick() {
            --this.delay;
            return this.delay <= 0;
        }

        public void reset() {
            this.delay = delay;
        }
    }
}

