/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.tile;

import com.alcatrazescapee.alcatrazcore.tile.TileCore;
import com.alcatrazescapee.alcatrazcore.util.CoreHelpers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public abstract class TileInventory
extends TileCore {
    protected final ItemStackHandler inventory;

    public TileInventory(int numSlots) {
        this.inventory = new ItemStackHandler(numSlots);
    }

    public void setAndUpdateSlots(int slot) {
        this.func_70296_d();
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        super.func_145839_a(nbt);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(nbt);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbt);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.handleUpdateTag(nbt);
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null ? this.inventory : super.getCapability(capability, facing));
    }

    @Override
    public void onBreakBlock() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            CoreHelpers.dropItemInWorld(this.field_145850_b, this.field_174879_c, this.inventory.getStackInSlot(i));
        }
        super.onBreakBlock();
    }
}

