/*
 * Decompiled with CFR 0.152.
 */
package io.github.xcube16.iseedragons.asm.helper;

import io.github.xcube16.iseedragons.ISD;
import io.github.xcube16.iseedragons.asm.PatchResult;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class PatchHelper {
    public static PatchResult muteMethod(MethodNode method) {
        boolean flag = false;
        for (AbstractInsnNode ip = method.instructions.getFirst(); ip != null; ip = ip.getNext()) {
            if (ip.getOpcode() != 185) continue;
            MethodInsnNode call = (MethodInsnNode)ip;
            if (!call.owner.equals("org/apache/logging/log4j/Logger") || !call.name.equals("error") || !call.desc.equals("(Ljava/lang/String;Ljava/lang/Throwable;)V")) continue;
            method.instructions.insert((AbstractInsnNode)call, (AbstractInsnNode)new InsnNode(88));
            method.instructions.insert((AbstractInsnNode)call, (AbstractInsnNode)new InsnNode(87));
            ip = call.getPrevious();
            method.instructions.remove((AbstractInsnNode)call);
            flag = true;
        }
        return flag ? PatchResult.NO_FLAGS : PatchResult.NO_MUTATION;
    }

    public static MethodNode findMethod(ClassNode node, String name) throws NoSuchMethodException {
        return PatchHelper.findMethod(node, name, null);
    }

    public static MethodNode findMethod(ClassNode node, String name, @Nullable String desc) throws NoSuchMethodException {
        Optional<MethodNode> method = node.methods.stream().filter(m -> m.name.equals(name)).filter(m -> desc == null || m.desc.equals(desc)).findFirst();
        if (!method.isPresent()) {
            ISD.logger.warn("Failed to find loadCustomAdvancements() method");
            throw new NoSuchMethodException(node.name + " " + name + " " + desc);
        }
        return method.get();
    }
}

