/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.util;

import c4.champions.Champions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.Level;

public class JsonUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T[] fromJson(@Nonnull TypeToken<T[]> token, @Nonnull File file, @Nonnull T[] defaults) {
        if (!file.exists()) {
            JsonUtil.toJson(token, file, defaults);
            return defaults;
        }
        try (FileReader reader = new FileReader(file);){
            Object[] objectArray = (Object[])GSON.fromJson((Reader)reader, token.getType());
            return objectArray;
        }
        catch (IOException e) {
            Champions.logger.log(Level.ERROR, "Error reading Json file");
            return defaults;
        }
    }

    private static <T> void toJson(@Nonnull TypeToken<T[]> token, @Nonnull File file, @Nonnull T[] defaults) {
        if (!file.exists()) {
            try {
                FileUtils.forceMkdirParent((File)file);
                file.createNewFile();
            }
            catch (IOException e) {
                Champions.logger.log(Level.ERROR, "Error creating Json file");
                return;
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(JsonUtil.getJson(defaults, token));
        }
        catch (IOException e) {
            Champions.logger.log(Level.ERROR, "Error creating Json file");
        }
    }

    private static <T> String getJson(@Nonnull T[] elements, @Nonnull TypeToken<T[]> token) {
        return GSON.toJson(elements, token.getType());
    }
}

