/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.capability;

import c4.champions.Champions;
import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.core.AffixBase;
import c4.champions.common.affix.filter.AffixFilter;
import c4.champions.common.affix.filter.AffixFilterManager;
import c4.champions.common.capability.Championship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.config.ConfigHandler;
import c4.champions.common.rank.Rank;
import c4.champions.common.rank.RankManager;
import c4.champions.common.util.ChampionHelper;
import c4.champions.integrations.gamestages.ChampionStages;
import c4.champions.network.NetworkHandler;
import c4.champions.network.PacketSyncAffix;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public final class CapabilityChampionship {
    @CapabilityInject(value=IChampionship.class)
    public static final Capability<IChampionship> CHAMPION_CAP = null;
    public static final EnumFacing DEFAULT_FACING = null;
    public static final ResourceLocation ID = new ResourceLocation("champions", "championship");
    private static final String AFFIX_TAG = "affixes";
    private static final String TIER_TAG = "tier";
    private static final String DATA_TAG = "data";
    private static final String NAME_TAG = "name";

    @Nullable
    public static IChampionship getChampionship(EntityLiving entityIn) {
        if (entityIn != null && entityIn.hasCapability(CHAMPION_CAP, DEFAULT_FACING)) {
            return (IChampionship)entityIn.getCapability(CHAMPION_CAP, DEFAULT_FACING);
        }
        return null;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IChampionship.class, (Capability.IStorage)new Capability.IStorage<IChampionship>(){

            public NBTBase writeNBT(Capability<IChampionship> capability, IChampionship instance, EnumFacing side) {
                NBTTagCompound compound = new NBTTagCompound();
                Rank rank = instance.getRank();
                if (rank != null) {
                    if (rank.getTier() > 0) {
                        NBTTagList list = new NBTTagList();
                        for (String id : instance.getAffixes()) {
                            NBTTagCompound tag = new NBTTagCompound();
                            tag.func_74778_a("identifier", id);
                            tag.func_74782_a(CapabilityChampionship.DATA_TAG, (NBTBase)instance.getAffixData(id));
                            list.func_74742_a((NBTBase)tag);
                        }
                        compound.func_74782_a(CapabilityChampionship.AFFIX_TAG, (NBTBase)list);
                        compound.func_74778_a(CapabilityChampionship.NAME_TAG, instance.getName());
                    }
                    compound.func_74768_a(CapabilityChampionship.TIER_TAG, rank.getTier());
                }
                return compound;
            }

            public void readNBT(Capability<IChampionship> capability, IChampionship instance, EnumFacing side, NBTBase nbt) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                if (compound.func_74764_b(CapabilityChampionship.TIER_TAG)) {
                    int tier = compound.func_74762_e(CapabilityChampionship.TIER_TAG);
                    instance.setRank(RankManager.getRankForTier(tier));
                    if (tier > 0) {
                        NBTTagList list = compound.func_150295_c(CapabilityChampionship.AFFIX_TAG, 10);
                        HashMap affixes = Maps.newHashMap();
                        for (int i = 0; i < list.func_74745_c(); ++i) {
                            NBTTagCompound tag = list.func_150305_b(i);
                            String id = tag.func_74779_i("identifier");
                            AffixFilter filter = AffixFilterManager.getAffixFilter(id);
                            if (filter == null || !filter.isEnabled()) continue;
                            affixes.put(tag.func_74779_i("identifier"), tag.func_74775_l(CapabilityChampionship.DATA_TAG));
                        }
                        instance.setAffixData(affixes);
                        instance.setName(compound.func_74779_i(CapabilityChampionship.NAME_TAG));
                    }
                }
            }
        }, Championship::new);
    }

    public static ICapabilityProvider createProvider(IChampionship championship) {
        return new Provider(championship, CHAMPION_CAP, DEFAULT_FACING);
    }

    @Mod.EventBusSubscriber(modid="champions")
    public static class EventHandler {
        @SubscribeEvent
        public static void attachCapabilities(AttachCapabilitiesEvent<Entity> evt) {
            Entity entity = (Entity)evt.getObject();
            if (ChampionHelper.isValidChampion(entity) && ChampionHelper.isValidDimension(entity.field_71093_bK)) {
                evt.addCapability(ID, CapabilityChampionship.createProvider(new Championship()));
            }
        }

        @SubscribeEvent
        public static void entityJoin(EntityJoinWorldEvent evt) {
            EntityLiving living;
            IChampionship chp;
            Entity entity = evt.getEntity();
            if (!entity.field_70170_p.field_72995_K && ChampionHelper.isValidChampion(entity) && (chp = CapabilityChampionship.getChampionship(living = (EntityLiving)entity)) != null && chp.getRank() == null) {
                Rank rank = ChampionHelper.generateRank(living);
                chp.setRank(rank);
                if (rank.getTier() > 0) {
                    Set<String> affixes = ChampionHelper.generateAffixes(rank, living, new String[0]);
                    chp.setAffixes(affixes);
                    chp.setName(ChampionHelper.generateRandomName());
                    chp.getRank().applyGrowth((EntityLivingBase)living);
                    for (String s : chp.getAffixes()) {
                        AffixBase affix = AffixRegistry.getAffix(s);
                        if (affix == null) continue;
                        affix.onInitialSpawn(living, chp);
                    }
                }
            }
        }

        @SubscribeEvent
        public static void entitySpawn(LivingSpawnEvent.SpecialSpawn evt) {
            EntityLiving living;
            IChampionship chp;
            Entity entity = evt.getEntity();
            if (!entity.field_70170_p.field_72995_K && ChampionHelper.isValidChampion(entity) && (chp = CapabilityChampionship.getChampionship(living = (EntityLiving)entity)) != null) {
                if (evt.getSpawner() != null && !ConfigHandler.championSpawners) {
                    chp.setRank(RankManager.getEmptyRank());
                    return;
                }
                if (Champions.isGameStagesLoaded && !ChampionStages.canSpawn(living)) {
                    chp.setRank(RankManager.getEmptyRank());
                    return;
                }
                if (chp.getRank() == null) {
                    Rank rank = ChampionHelper.generateRank(living);
                    chp.setRank(rank);
                    if (rank.getTier() > 0) {
                        Set<String> affixes = ChampionHelper.generateAffixes(rank, living, new String[0]);
                        chp.setAffixes(affixes);
                        chp.setName(ChampionHelper.generateRandomName());
                        chp.getRank().applyGrowth((EntityLivingBase)living);
                        for (String s : chp.getAffixes()) {
                            AffixBase affix = AffixRegistry.getAffix(s);
                            if (affix == null) continue;
                            affix.onInitialSpawn(living, chp);
                        }
                    }
                }
            }
        }

        @SubscribeEvent
        public static void startTracking(PlayerEvent.StartTracking evt) {
            Entity entity = evt.getTarget();
            if (evt.getEntityPlayer() instanceof EntityPlayerMP) {
                IChampionship chp;
                EntityPlayerMP playerMP = (EntityPlayerMP)evt.getEntityPlayer();
                if (ChampionHelper.isValidChampion(entity) && (chp = CapabilityChampionship.getChampionship((EntityLiving)entity)) != null && ChampionHelper.isElite(chp.getRank())) {
                    NetworkHandler.INSTANCE.sendTo((IMessage)new PacketSyncAffix(entity.func_145782_y(), chp.getRank().getTier(), (Map<String, NBTTagCompound>)chp.getAffixData(), chp.getName()), playerMP);
                }
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        final Capability<IChampionship> capability;
        final EnumFacing facing;
        final IChampionship instance;

        Provider(IChampionship instance, Capability<IChampionship> capability, @Nullable EnumFacing facing) {
            this.instance = instance;
            this.capability = capability;
            this.facing = facing;
        }

        public boolean hasCapability(@Nullable Capability<?> capability, EnumFacing facing) {
            return capability == this.getCapability();
        }

        public <T> T getCapability(@Nullable Capability<T> capability, EnumFacing facing) {
            return (T)(capability == this.getCapability() ? this.getCapability().cast((Object)this.instance) : null);
        }

        final Capability<IChampionship> getCapability() {
            return this.capability;
        }

        EnumFacing getFacing() {
            return this.facing;
        }

        final IChampionship getInstance() {
            return this.instance;
        }

        public NBTBase serializeNBT() {
            return this.getCapability() != null ? this.getCapability().writeNBT((Object)this.getInstance(), this.getFacing()) : new NBTTagCompound();
        }

        public void deserializeNBT(NBTBase nbt) {
            if (this.getCapability() != null) {
                this.getCapability().readNBT((Object)this.getInstance(), this.getFacing(), nbt);
            }
        }
    }
}

