/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common.affix.core;

import c4.champions.common.affix.AffixRegistry;
import c4.champions.common.affix.IAffix;
import c4.champions.common.affix.core.AffixCategory;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.config.ConfigHandler;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public abstract class AffixBase
implements IAffix {
    protected static final Random rand = new Random();
    private final String identifier;
    private final AffixCategory category;
    private final int tier;

    public AffixBase(String identifier, AffixCategory category) {
        this(identifier, category, 1);
    }

    public AffixBase(String identifier, AffixCategory category, int tier) {
        this.identifier = identifier;
        this.category = category;
        this.tier = tier;
        AffixRegistry.registerAffix(identifier, this);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public AffixCategory getCategory() {
        return this.category;
    }

    @Override
    public void onInitialSpawn(EntityLiving entity, IChampionship cap) {
    }

    @Override
    public void onSpawn(EntityLiving entity, IChampionship cap) {
    }

    @Override
    public void onUpdate(EntityLiving entity, IChampionship cap) {
    }

    @Override
    public void onAttack(EntityLiving entity, IChampionship cap, EntityLivingBase target, DamageSource source, float amount, LivingAttackEvent evt) {
    }

    @Override
    public void onAttacked(EntityLiving entity, IChampionship cap, DamageSource source, float amount, LivingAttackEvent evt) {
    }

    @Override
    public float onHurt(EntityLiving entity, IChampionship cap, DamageSource source, float amount, float newAmount) {
        return newAmount;
    }

    @Override
    public float onDamaged(EntityLiving entity, IChampionship cap, DamageSource source, float amount, float newAmount) {
        return newAmount;
    }

    @Override
    public float onHealed(EntityLiving entity, IChampionship cap, float amount, float newAmount) {
        return newAmount;
    }

    @Override
    public void onKnockback(EntityLiving entity, IChampionship cap, LivingKnockBackEvent evt) {
    }

    @Override
    public void onDeath(EntityLiving entity, IChampionship cap, DamageSource source, LivingDeathEvent evt) {
    }

    @Override
    public boolean canApply(EntityLiving entity) {
        return true;
    }

    @Override
    public boolean isCompatibleWith(IAffix affix) {
        return affix != this;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public static boolean isValidAffixTarget(EntityLiving mob, EntityLivingBase target, boolean checkSight) {
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (checkSight && !mob.func_70685_l((Entity)target)) {
            return false;
        }
        IAttributeInstance iattributeinstance = mob.func_110148_a(SharedMonsterAttributes.field_111265_b);
        double targetRange = iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
        targetRange = ConfigHandler.affix.abilityRange == 0 ? targetRange : Math.min(targetRange, (double)ConfigHandler.affix.abilityRange);
        return (double)mob.func_70032_d((Entity)target) <= targetRange;
    }
}

