/*
 * Decompiled with CFR 0.152.
 */
package dttraverse.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenCocoa;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenVine;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import prospector.traverse.world.TraverseWorld;

public final class SpeciesMiniJungle
extends Species {
    public SpeciesMiniJungle(TreeFamily treeFamily) {
        super(new ResourceLocation("dttraverse", "mini_jungle"), treeFamily);
        this.setBasicGrowingParameters(0.4f, 9.0f, 2, 4, 0.9f);
        this.envFactor(BiomeDictionary.Type.HOT, 1.15f);
        this.envFactor(BiomeDictionary.Type.DRY, 1.2f);
        this.envFactor(BiomeDictionary.Type.FOREST, 1.15f);
        this.setGrowthLogicKit(treeFamily.getCommonSpecies().getGrowthLogicKit());
        this.setupStandardSeedDropping();
        this.addGenFeature((IGenFeature)new FeatureGenCocoa());
        this.addGenFeature((IGenFeature)new FeatureGenVine().setQuantity(16).setMaxLength(6));
        this.getFamily().addSpeciesLocationOverride((world, trunkPos) -> world.func_180494_b(trunkPos).equals(TraverseWorld.miniJungleBiome) ? this : NULLSPECIES);
    }

    public boolean isBiomePerfect(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE);
    }

    public ItemStack getSeedStack(int qty) {
        return this.getFamily().getCommonSpecies().getSeedStack(qty);
    }

    public Seed getSeed() {
        return this.getFamily().getCommonSpecies().getSeed();
    }
}

