/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.MineshaftVariantSettings;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public class LayeredIntersection5
extends MineshaftPiece {
    private static final int SECONDARY_AXIS_LEN = 5;
    private static final int Y_AXIS_LEN = 10;
    private static final int MAIN_AXIS_LEN = 5;
    private static final int LOCAL_X_END = 4;
    private static final int LOCAL_Y_END = 9;
    private static final int LOCAL_Z_END = 4;

    public LayeredIntersection5() {
    }

    public LayeredIntersection5(int i, int pieceChainLen, Random random, StructureBoundingBox blockBox, EnumFacing direction, MineshaftVariantSettings settings) {
        super(i, pieceChainLen, settings);
        this.func_186164_a(direction);
        this.field_74887_e = blockBox;
    }

    public static StructureBoundingBox determineBoxPosition(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing direction) {
        StructureBoundingBox blockBox = new StructureBoundingBox(x, y, z, x, y + 10 - 1, z);
        switch (direction) {
            default: {
                blockBox.field_78893_d = x + 4;
                blockBox.field_78896_c = z - 4;
                break;
            }
            case SOUTH: {
                blockBox.field_78897_a = x - 4;
                blockBox.field_78892_f = z + 4;
                break;
            }
            case WEST: {
                blockBox.field_78897_a = x - 4;
                blockBox.field_78896_c = z - 4;
                break;
            }
            case EAST: {
                blockBox.field_78893_d = x + 4;
                blockBox.field_78892_f = z + 4;
            }
        }
        StructureComponent intersectingPiece = StructureComponent.func_74883_a(list, (StructureBoundingBox)blockBox);
        return intersectingPiece != null ? null : blockBox;
    }

    @Override
    public void func_74861_a(StructureComponent structurePiece, List<StructureComponent> list, Random random) {
        EnumFacing direction = this.func_186165_e();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, EnumFacing.WEST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 5, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 5, this.field_74887_e.field_78892_f, EnumFacing.WEST, this.func_74877_c(), this.pieceChainLen);
                break;
            }
            case WEST: 
            case EAST: {
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 5, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c(), this.pieceChainLen);
                BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 5, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c(), this.pieceChainLen);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_74875_a(World world, Random random, StructureBoundingBox box) {
        if (this.func_74860_a(world, box)) {
            return false;
        }
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 4, 4)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 1, 0, 4, 9, 4, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.settings.replacementRate, 0, 0, 0, 4, 0, 4, this.getFloorSelector());
        this.fill(world, box, 0, 1, 0, 4, 8, 3, AIR);
        this.fill(world, box, 0, 5, 4, 4, 8, 4, AIR);
        this.replaceAir(world, box, 0, 0, 0, 4, 0, 3, this.getMainBlock());
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH), 2, 1, 0, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH), 2, 1, 1, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 0, 1, 2, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 1, 1, 2, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 3, 1, 2, box);
        this.chanceAddBlock(world, random, 0.5f, Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST), 4, 1, 2, box);
        this.fill(world, box, 0, 5, 0, 4, 5, 4, this.getMainBlock());
        this.chanceReplaceNonAir(world, box, random, 0.5f, 0, 5, 0, 4, 5, 4, this.getMainSelector());
        this.fill(world, box, 1, 5, 1, 3, 5, 3, AIR);
        this.fill(world, box, 1, 1, 1, 1, 8, 1, this.getSupportBlock());
        this.fill(world, box, 3, 1, 1, 3, 8, 1, this.getSupportBlock());
        this.fill(world, box, 1, 1, 3, 1, 8, 3, this.getSupportBlock());
        this.fill(world, box, 3, 1, 3, 3, 8, 3, this.getSupportBlock());
        IBlockState LADDER = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.SOUTH);
        this.fill(world, box, 2, 1, 3, 2, 5, 3, LADDER);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 4, 8, 4);
        this.addVines(world, box, random, 1, 0, 1, 3, 9, 3);
        return true;
    }
}

