/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util.timer;

import java.text.DecimalFormat;
import java.util.stream.LongStream;

public interface ITimer {
    public static final DecimalFormat FORMAT = new DecimalFormat("0.0");

    public String getName();

    public void update();

    public void start();

    public void stop();

    public LongStream results();

    default public String avgString() {
        return FORMAT.format(this.avg()) + "ms";
    }

    default public String minString() {
        return FORMAT.format(this.min()) + "ms";
    }

    default public String maxString() {
        return FORMAT.format(this.max()) + "ms";
    }

    default public double avg() {
        return this.results().average().orElse(0.0) / 1000000.0;
    }

    default public double min() {
        return (double)this.results().min().orElse(0L) / 1000000.0;
    }

    default public double max() {
        return (double)this.results().max().orElse(0L) / 1000000.0;
    }
}

