/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.util;

import meldexun.matrixutil.Matrix4f;
import meldexun.renderlib.integration.Optifine;
import meldexun.renderlib.util.Frustum;
import meldexun.renderlib.util.GLUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;

public class RenderUtil {
    private static int frame;
    private static double partialTick;
    private static double partialTickDelta;
    private static int recursive;
    private static Matrix4f projectionMatrix;
    private static Matrix4f modelViewMatrix;
    private static Matrix4f projectionModelViewMatrix;
    private static double cameraEntityX;
    private static double cameraEntityY;
    private static double cameraEntityZ;
    private static double cameraOffsetX;
    private static double cameraOffsetY;
    private static double cameraOffsetZ;
    private static double cameraX;
    private static double cameraY;
    private static double cameraZ;
    private static Frustum frustum;

    public static void update(double partialTickIn) {
        ++frame;
        partialTickDelta = partialTickIn - partialTick;
        if (partialTickDelta < 0.0) {
            partialTickDelta += 1.0;
        }
        partialTick = partialTickIn;
        recursive = 0;
    }

    public static void updateCamera() {
        Minecraft mc = Minecraft.func_71410_x();
        Entity cameraEntity = mc.func_175606_aa();
        Vec3d cameraOffset = ActiveRenderInfo.getCameraPosition();
        if (!Optifine.isOptifineDetected() || !Optifine.isShadowPass()) {
            ++recursive;
        }
        projectionMatrix = GLUtil.getMatrix(2983);
        modelViewMatrix = GLUtil.getMatrix(2982);
        projectionModelViewMatrix = projectionMatrix.copy();
        projectionModelViewMatrix.multiply(modelViewMatrix);
        cameraEntityX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * partialTick;
        cameraEntityY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * partialTick;
        cameraEntityZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * partialTick;
        cameraOffsetX = cameraOffset.field_72450_a;
        cameraOffsetY = cameraOffset.field_72448_b;
        cameraOffsetZ = cameraOffset.field_72449_c;
        cameraX = cameraEntityX + cameraOffsetX;
        cameraY = cameraEntityY + cameraOffsetY;
        cameraZ = cameraEntityZ + cameraOffsetZ;
        frustum = new Frustum(projectionModelViewMatrix, cameraEntityX, cameraEntityY, cameraEntityZ);
    }

    public static int getFrame() {
        return frame;
    }

    public static double getPartialTick() {
        return partialTick;
    }

    public static double getPartialTickDelta() {
        return partialTickDelta;
    }

    public static boolean isRecursive() {
        return recursive > 1;
    }

    public static Matrix4f getProjectionMatrix() {
        return projectionMatrix;
    }

    public static Matrix4f getModelViewMatrix() {
        return modelViewMatrix;
    }

    public static Matrix4f getProjectionModelViewMatrix() {
        return projectionModelViewMatrix;
    }

    public static double getCameraEntityX() {
        return cameraEntityX;
    }

    public static double getCameraEntityY() {
        return cameraEntityY;
    }

    public static double getCameraEntityZ() {
        return cameraEntityZ;
    }

    public static double getCameraOffsetX() {
        return cameraOffsetX;
    }

    public static double getCameraOffsetY() {
        return cameraOffsetY;
    }

    public static double getCameraOffsetZ() {
        return cameraOffsetZ;
    }

    public static double getCameraX() {
        return cameraX;
    }

    public static double getCameraY() {
        return cameraY;
    }

    public static double getCameraZ() {
        return cameraZ;
    }

    public static Frustum getFrustum() {
        return frustum;
    }
}

