/*
 * Decompiled with CFR 0.152.
 */
package meldexun.renderlib.renderer.tileentity;

import java.util.ArrayDeque;
import java.util.Deque;
import meldexun.renderlib.RenderLib;
import meldexun.renderlib.api.IBoundingBoxCache;
import meldexun.renderlib.api.ILoadable;
import meldexun.renderlib.api.ITileEntityRendererCache;
import meldexun.renderlib.integration.ValkyrienSkies;
import meldexun.renderlib.renderer.tileentity.TileEntityRenderList;
import meldexun.renderlib.util.RenderUtil;
import meldexun.renderlib.util.TileEntityUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;

public class TileEntityRenderer {
    protected int renderedTileEntities;
    protected int occludedTileEntities;
    protected int totalTileEntities;
    private int camChunkX;
    private int camChunkZ;
    private int renderDist;
    private final Deque<TileEntityRenderList> tileEntityListQueue = new ArrayDeque<TileEntityRenderList>();

    public void setup(ICamera frustum, float partialTicks, double camX, double camY, double camZ) {
        Minecraft mc = Minecraft.func_71410_x();
        this.renderedTileEntities = 0;
        this.occludedTileEntities = 0;
        this.totalTileEntities = mc.field_71441_e.field_147482_g.size();
        this.camChunkX = MathHelper.func_76128_c((double)RenderUtil.getCameraEntityX()) >> 4;
        this.camChunkZ = MathHelper.func_76128_c((double)RenderUtil.getCameraEntityZ()) >> 4;
        this.renderDist = mc.field_71474_y.field_151451_c;
        TileEntityRenderList tileEntityList = new TileEntityRenderList();
        TileEntityUtil.processTileEntities((World)mc.field_71441_e, tileEntities -> tileEntities.forEach(tileEntity -> {
            if (!this.shouldRender((TileEntity)tileEntity, frustum, partialTicks, camX, camY, camZ)) {
                return;
            }
            if (this.isOcclusionCulled(tileEntity)) {
                ++this.occludedTileEntities;
            } else {
                ++this.renderedTileEntities;
                tileEntityList.addTileEntity((TileEntity)tileEntity);
            }
        }));
        this.tileEntityListQueue.addLast(tileEntityList);
    }

    public void reset() {
        this.tileEntityListQueue.removeLast();
    }

    public void renderTileEntities(float partialTicks) {
        this.renderTileEntities(partialTicks, this.tileEntityListQueue.getLast());
    }

    protected void renderTileEntities(float partialTicks, TileEntityRenderList tileEntityList) {
        for (TileEntity tileEntity : tileEntityList.getTileEntities()) {
            this.preRenderTileEntity(tileEntity);
            TileEntityRendererDispatcher.field_147556_a.func_180546_a(tileEntity, partialTicks, -1);
            this.postRenderTileEntity();
        }
    }

    private boolean shouldRender(TileEntity tileEntity, ICamera frustum, float partialTicks, double camX, double camY, double camZ) {
        if (!((ITileEntityRendererCache)tileEntity).hasRenderer()) {
            return false;
        }
        if (!((ILoadable)tileEntity).isChunkLoaded()) {
            return false;
        }
        if (!tileEntity.shouldRenderInPass(0) && !tileEntity.shouldRenderInPass(1)) {
            return false;
        }
        if (this.isOutsideOfRenderDist(tileEntity)) {
            return false;
        }
        if (!((IBoundingBoxCache)tileEntity).getCachedBoundingBox().isVisible(frustum)) {
            this.setCanBeOcclusionCulled(tileEntity, false);
            return false;
        }
        if (tileEntity.func_145835_a(camX, camY, camZ) >= tileEntity.func_145833_n()) {
            this.setCanBeOcclusionCulled(tileEntity, false);
            return false;
        }
        this.setCanBeOcclusionCulled(tileEntity, true);
        return true;
    }

    private boolean isOutsideOfRenderDist(TileEntity tileEntity) {
        BlockPos pos = RenderLib.isValkyrienSkiesInstalled ? ValkyrienSkies.getPos(tileEntity) : tileEntity.func_174877_v();
        return Math.abs((pos.func_177958_n() >> 4) - this.camChunkX) > this.renderDist || Math.abs((pos.func_177952_p() >> 4) - this.camChunkZ) > this.renderDist;
    }

    protected <T extends TileEntity> void setCanBeOcclusionCulled(T tileEntity, boolean canBeOcclusionCulled) {
    }

    protected <T extends TileEntity> boolean isOcclusionCulled(T tileEntity) {
        return false;
    }

    protected void preRenderTileEntity(TileEntity tileEntity) {
        tileEntity.shouldRenderInPass(MinecraftForgeClient.getRenderPass());
    }

    protected void postRenderTileEntity() {
    }

    public int getRenderedTileEntities() {
        return this.renderedTileEntities;
    }

    public int getOccludedTileEntities() {
        return this.occludedTileEntities;
    }

    public int getTotalTileEntities() {
        return this.totalTileEntities;
    }
}

