/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.component.path;

import com.fantasticsource.tools.TrigLookupTable;
import com.fantasticsource.tools.component.CDouble;
import com.fantasticsource.tools.component.path.CPath;
import com.fantasticsource.tools.datastructures.VectorN;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class CPathSinuous
extends CPath {
    public CPath highPointOffsetPath;
    public double thetaPerSec;
    public double thetaOffset;

    public CPathSinuous() {
    }

    public CPathSinuous(CPath highPointOffsetPath, double thetaPerSec) {
        this(highPointOffsetPath, thetaPerSec, 0.0);
    }

    public CPathSinuous(CPath highPointOffsetPath, double thetaPerSec, double thetaOffset) {
        this.highPointOffsetPath = highPointOffsetPath;
        this.thetaPerSec = thetaPerSec;
        this.thetaOffset = thetaOffset;
    }

    @Override
    public VectorN getRelativePositionInternal(long time) {
        double normalizedScalar = TrigLookupTable.TRIG_TABLE_1024.sin(Math.PI * 2 * (this.thetaOffset + this.thetaPerSec * (double)time / 1000.0));
        return this.highPointOffsetPath.getRelativePosition(time).scale(normalizedScalar);
    }

    @Override
    public CPathSinuous write(ByteBuf buf) {
        super.write(buf);
        CPathSinuous.writeMarked(buf, this.highPointOffsetPath);
        buf.writeDouble(this.thetaPerSec);
        buf.writeDouble(this.thetaOffset);
        return this;
    }

    @Override
    public CPathSinuous read(ByteBuf buf) {
        super.read(buf);
        this.highPointOffsetPath = (CPath)CPathSinuous.readMarked(buf);
        this.thetaPerSec = buf.readDouble();
        this.thetaOffset = buf.readDouble();
        return this;
    }

    @Override
    public CPathSinuous save(OutputStream stream) {
        super.save(stream);
        CPathSinuous.saveMarked(stream, this.highPointOffsetPath);
        new CDouble().set(this.thetaPerSec).save(stream).set(this.thetaOffset).save(stream);
        return this;
    }

    @Override
    public CPathSinuous load(InputStream stream) {
        super.load(stream);
        CDouble cd = new CDouble();
        this.highPointOffsetPath = (CPath)CPathSinuous.loadMarked(stream);
        this.thetaPerSec = cd.load((InputStream)stream).value;
        this.thetaOffset = cd.load((InputStream)stream).value;
        return this;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74782_a("highPointOffsetPath", (NBTBase)CPathSinuous.serializeMarked(this.highPointOffsetPath));
        compound.func_74780_a("thetaPerSec", this.thetaPerSec);
        compound.func_74780_a("thetaOffset", this.thetaOffset);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTBase nbt) {
        super.deserializeNBT(nbt);
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.highPointOffsetPath = (CPath)CPathSinuous.deserializeMarked(compound.func_74775_l("highPointOffsetPath"));
    }
}

