/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element;

import com.fantasticsource.mctools.gui.GUILeftClickEvent;
import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.other.GUILine;
import com.fantasticsource.mctools.gui.element.view.GUIPanZoomView;
import com.fantasticsource.mctools.gui.element.view.GUIScrollView;
import com.fantasticsource.mctools.gui.element.view.GUITooltipView;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GUIElement {
    public static final Color T_GRAY = new Color(-1431655817);
    public static final byte AP_CENTER = -1;
    public static final byte AP_LEFT_TO_RIGHT_TOP_TO_BOTTOM = 0;
    public static final byte AP_CENTERED_H_TOP_TO_BOTTOM = 8;
    public static final byte AP_X_0_TOP_TO_BOTTOM = 10;
    public static final byte AP_Y_0_LEFT_TO_RIGHT = 11;
    public final ArrayList<Runnable> onClickActions = new ArrayList();
    public final ArrayList<Runnable> onRecalcActions = new ArrayList();
    public final ArrayList<Runnable> onEditActions = new ArrayList();
    public final ArrayList<Predicate<GUIElement>> onRemoveChildActions = new ArrayList();
    public double x;
    public double y;
    public double width;
    public double height;
    public GUIElement parent = null;
    public ArrayList<GUIElement> children = new ArrayList();
    public Object tooltip = null;
    public boolean autoplace = false;
    protected double autoX = 0.0;
    protected double autoY = 0.0;
    protected double furthestX = 0.0;
    protected double furthestY = 0.0;
    protected byte subElementAutoplaceMethod;
    public GUIScreen screen;
    protected boolean active = false;
    protected boolean externalDeactivation = false;
    protected boolean useParentScissor = false;
    private ArrayList<GUIElement> linkedMouseActivity = new ArrayList();
    private ArrayList<GUIElement> linkedMouseActivityReverse = new ArrayList();
    protected double dragStartX;
    protected double dragStartY;

    public GUIElement(GUIScreen screen, double width, double height) {
        this(screen, width, height, 0);
    }

    public GUIElement(GUIScreen screen, double width, double height, byte subElementAutoplaceMethod) {
        this(screen, 0.0, 0.0, width, height, subElementAutoplaceMethod);
        this.autoplace = true;
    }

    public GUIElement(GUIScreen screen, double x, double y, double width, double height) {
        this(screen, x, y, width, height, 0);
    }

    public GUIElement(GUIScreen screen, double x, double y, double width, double height, byte subElementAutoplaceMethod) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.subElementAutoplaceMethod = subElementAutoplaceMethod;
    }

    public GUIElement useParentScissor(boolean useParentScissor) {
        this.useParentScissor = useParentScissor;
        return this;
    }

    public GUIElement setTooltip(String tooltip) {
        if (tooltip == null || tooltip.trim().equals("")) {
            this.tooltip = null;
            return this;
        }
        if (!(this.tooltip instanceof GUITooltipView)) {
            this.tooltip = new GUITooltipView(this.screen);
        }
        ((GUITooltipView)this.tooltip).setTooltip(tooltip);
        return this;
    }

    public GUIElement setTooltip(ItemStack stack) {
        this.tooltip = stack;
        return this;
    }

    public boolean isWithin(double x, double y) {
        double xx = this.absoluteX();
        double yy = this.absoluteY();
        return xx <= x && x < xx + this.absoluteWidth() && yy <= y && y < yy + this.absoluteHeight();
    }

    private int[] preDraw() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)this.x, (double)this.y, (double)0.0);
        GlStateManager.func_179139_a((double)this.width, (double)this.height, (double)1.0);
        int[] lastScissor = new int[4];
        System.arraycopy(GUIScreen.currentScissor, 0, lastScissor, 0, 4);
        if (!this.useParentScissor) {
            if (this instanceof GUILine) {
                GUIScreen.currentScissor[0] = (int)Tools.max(new float[]{GUIScreen.currentScissor[0], (float)this.absolutePxX() - ((GUILine)this).thickness});
                GUIScreen.currentScissor[1] = (int)Tools.max(new float[]{GUIScreen.currentScissor[1], (float)this.absolutePxY() - ((GUILine)this).thickness});
                GUIScreen.currentScissor[2] = (int)Tools.min(new float[]{GUIScreen.currentScissor[2], (float)(this.absolutePxX() + this.absolutePxWidth()) + ((GUILine)this).thickness * 2.0f});
                GUIScreen.currentScissor[3] = (int)Tools.min(new float[]{GUIScreen.currentScissor[3], (float)(this.absolutePxY() + this.absolutePxHeight()) + ((GUILine)this).thickness * 2.0f});
            } else {
                GUIScreen.currentScissor[0] = Tools.max(GUIScreen.currentScissor[0], this.absolutePxX());
                GUIScreen.currentScissor[1] = Tools.max(GUIScreen.currentScissor[1], this.absolutePxY());
                GUIScreen.currentScissor[2] = Tools.min(GUIScreen.currentScissor[2], this.absolutePxX() + this.absolutePxWidth());
                GUIScreen.currentScissor[3] = Tools.min(GUIScreen.currentScissor[3], this.absolutePxY() + this.absolutePxHeight());
            }
        }
        if (!this.screen.scissor()) {
            GUIScreen.currentScissor = lastScissor;
            GlStateManager.func_179121_F();
            return null;
        }
        return lastScissor;
    }

    protected final void drawChildren() {
        if (this.children.size() > 0 && this.width > 0.0 && this.height > 0.0) {
            for (GUIElement element : this.children.toArray(new GUIElement[0])) {
                element.tick();
                int[] lastScissor = element.preDraw();
                if (lastScissor == null) continue;
                element.draw();
                element.postDraw(lastScissor);
            }
        }
        if (this.isMouseWithin()) {
            if (this.tooltip instanceof GUITooltipView) {
                this.screen.tooltips.add((GUITooltipView)this.tooltip);
            } else if (this.tooltip instanceof ItemStack) {
                this.screen.tooltipStack = (ItemStack)this.tooltip;
            }
        }
    }

    private void postDraw(int[] lastScissor) {
        GUIScreen.currentScissor = lastScissor;
        GlStateManager.func_179121_F();
    }

    protected void tick() {
    }

    public void draw() {
        this.drawChildren();
    }

    public void mouseWheel(int delta) {
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.mouseWheel(delta);
        }
    }

    public boolean mousePressed(int button) {
        this.dragStartX = this.x;
        this.dragStartY = this.y;
        boolean result = false;
        if (button == 0 && this.isMouseWithin()) {
            result = true;
            this.setActive(true);
        }
        for (GUIElement child : (ArrayList)this.children.clone()) {
            result |= child.mousePressed(button);
        }
        return result;
    }

    public boolean mouseReleased(int button) {
        boolean result = false;
        if (button == 0) {
            if (this.active && this.isMouseWithin() && this.x == this.dragStartX && this.y == this.dragStartY) {
                if (!MinecraftForge.EVENT_BUS.post((Event)new GUILeftClickEvent(this.screen, this))) {
                    this.click();
                }
                result = true;
            }
            this.setActive(false);
        }
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.mouseReleased(button);
        }
        return result;
    }

    public void click() {
        for (Runnable action : this.onClickActions) {
            action.run();
        }
    }

    public GUIElement addClickActions(Runnable ... actions) {
        this.onClickActions.addAll(Arrays.asList(actions));
        return this;
    }

    public GUIElement addRecalcActions(Runnable ... actions) {
        this.onRecalcActions.addAll(Arrays.asList(actions));
        return this;
    }

    public GUIElement addEditActions(Runnable ... actions) {
        this.onEditActions.addAll(Arrays.asList(actions));
        return this;
    }

    public GUIElement addRemoveChildActions(Predicate<GUIElement> ... actions) {
        this.onRemoveChildActions.addAll(Arrays.asList(actions));
        return this;
    }

    public void mouseDrag(int button) {
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.mouseDrag(button);
        }
    }

    public final double absoluteX() {
        if (this.parent == null) {
            return this.x;
        }
        if (this.parent instanceof GUIPanZoomView) {
            return this.parent.absoluteX() + (this.x - ((GUIPanZoomView)this.parent).viewX) * ((GUIPanZoomView)this.parent).getZoom() * this.parent.absoluteWidth();
        }
        return this.parent.absoluteX() + this.x * this.parent.absoluteWidth();
    }

    public final double absoluteY() {
        if (this.parent == null) {
            return this.y;
        }
        if (this.parent instanceof GUIPanZoomView) {
            return this.parent.absoluteY() + (this.y - ((GUIPanZoomView)this.parent).viewY) * ((GUIPanZoomView)this.parent).getZoom() * this.parent.absoluteHeight();
        }
        if (this.parent instanceof GUIScrollView) {
            return this.parent.absoluteY() + (this.y - ((GUIScrollView)this.parent).top) * this.parent.absoluteHeight();
        }
        return this.parent.absoluteY() + this.y * this.parent.absoluteHeight();
    }

    public final GUIElement setAbsoluteX(double absX) {
        this.x = this.parent == null ? absX : (this.parent instanceof GUIPanZoomView ? (absX - this.parent.absoluteX()) / ((GUIPanZoomView)this.parent).getZoom() / this.parent.absoluteWidth() + ((GUIPanZoomView)this.parent).viewX : (absX - this.parent.absoluteX()) / this.parent.absoluteWidth());
        return this;
    }

    public final GUIElement setAbsoluteY(double absY) {
        this.y = this.parent == null ? absY : (this.parent instanceof GUIPanZoomView ? (absY - this.parent.absoluteY()) / ((GUIPanZoomView)this.parent).getZoom() / this.parent.absoluteHeight() + ((GUIPanZoomView)this.parent).viewY : (this.parent instanceof GUIScrollView ? (absY - this.parent.absoluteY()) / this.parent.absoluteHeight() + ((GUIScrollView)this.parent).top : (absY - this.parent.absoluteY()) / this.parent.absoluteHeight()));
        return this;
    }

    public final double absoluteWidth() {
        if (this.parent == null) {
            return this.width;
        }
        if (this.parent instanceof GUIPanZoomView) {
            return this.parent.absoluteWidth() * this.width * ((GUIPanZoomView)this.parent).getZoom();
        }
        return this.parent.absoluteWidth() * this.width;
    }

    public final double absoluteHeight() {
        if (this.parent == null) {
            return this.height;
        }
        if (this.parent instanceof GUIPanZoomView) {
            return this.parent.absoluteHeight() * this.height * ((GUIPanZoomView)this.parent).getZoom();
        }
        return this.parent.absoluteHeight() * this.height;
    }

    public final int absolutePxX() {
        return (int)Math.round(this.absoluteX() * (double)this.screen.pxWidth);
    }

    public final int absolutePxY() {
        return (int)Math.round(this.absoluteY() * (double)this.screen.pxHeight);
    }

    public final int absolutePxWidth() {
        return (int)Math.round(this.absoluteWidth() * (double)this.screen.pxWidth);
    }

    public final int absolutePxHeight() {
        return (int)Math.round(this.absoluteHeight() * (double)this.screen.pxHeight);
    }

    public final double mouseX() {
        return GUIScreen.mouseX;
    }

    public final double mouseY() {
        return GUIScreen.mouseY;
    }

    public final boolean isMouseWithin() {
        for (GUIElement element : this.linkedMouseActivityReverse) {
            if (!element.isWithin(this.mouseX(), this.mouseY())) continue;
            return true;
        }
        return this.isWithin(this.mouseX(), this.mouseY()) && (this.parent == null || this.parent.isMouseWithin());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public GUIElement recalc(int subIndexChanged) {
        this.recalcAndRepositionSubElements(subIndexChanged);
        this.postRecalc();
        return this;
    }

    public final void postRecalc() {
        for (Runnable action : this.onRecalcActions) {
            action.run();
        }
    }

    public GUIElement addAll(GUIElement ... elements) {
        for (GUIElement element : elements) {
            this.add(element);
        }
        return this;
    }

    public GUIElement add(GUIElement element) {
        return this.add(this.children.size(), element);
    }

    public GUIElement add(int index, GUIElement element) {
        element.parent = this;
        this.children.add(index, element);
        switch (this.subElementAutoplaceMethod) {
            case -1: {
                this.recalc(0);
                break;
            }
            default: {
                this.recalc(index);
            }
        }
        return element;
    }

    public void recalcAndRepositionSubElements(int startIndex) {
        double yy = 0.0;
        switch (this.subElementAutoplaceMethod) {
            case -1: {
                for (GUIElement element : this.children) {
                    element.recalc(0);
                    if (!element.autoplace) continue;
                    element.x = 0.5 - element.width * 0.5;
                    element.y = yy;
                    yy = Tools.max(yy, element.y + element.height);
                }
                yy *= 0.5;
                for (GUIElement element : this.children) {
                    if (!element.autoplace) continue;
                    element.y += 0.5 - yy;
                }
                break;
            }
            case 0: {
                GUIElement element;
                int i;
                if (this.size() <= 1 || startIndex != this.size() - 1) {
                    this.autoX = 0.0;
                    this.autoY = 0.0;
                    this.furthestX = 0.0;
                    this.furthestY = 0.0;
                    for (i = 0; i < startIndex; ++i) {
                        element = this.get(i);
                        if (!element.autoplace) continue;
                        this.autoX = element.x + element.width;
                        this.autoY = element.y;
                        this.furthestX = Tools.max(this.furthestX, this.autoX);
                        this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                    }
                }
                for (i = startIndex; i < this.size(); ++i) {
                    element = this.get(i);
                    element.recalc(0);
                    if (!element.autoplace) continue;
                    if (this.autoX != 0.0 && this.autoX + element.width > 1.0) {
                        element.x = 0.0;
                        element.y = this.furthestY;
                    } else {
                        element.x = this.autoX;
                        element.y = this.autoY;
                    }
                    this.autoX = element.x + element.width;
                    this.autoY = element.y;
                    this.furthestX = Tools.max(this.furthestX, this.autoX);
                    this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                }
                break;
            }
            case 8: {
                GUIElement element;
                int i;
                if (this.size() <= 1 || startIndex != this.size() - 1) {
                    this.autoY = 0.0;
                    this.furthestY = 0.0;
                    for (i = 0; i < startIndex; ++i) {
                        element = this.get(i);
                        if (!element.autoplace) continue;
                        this.autoY = element.y;
                        this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                    }
                }
                for (i = startIndex; i < this.size(); ++i) {
                    element = this.get(i);
                    element.recalc(0);
                    if (!element.autoplace) continue;
                    element.x = 0.5 - element.width / 2.0;
                    this.autoY = element.y = this.furthestY;
                    this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                }
                break;
            }
            case 10: {
                GUIElement element;
                int i;
                if (this.size() <= 1 || startIndex != this.size() - 1) {
                    this.autoY = 0.0;
                    this.furthestY = 0.0;
                    for (i = 0; i < startIndex; ++i) {
                        element = this.get(i);
                        if (!element.autoplace) continue;
                        this.autoY = element.y;
                        this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                    }
                }
                for (i = startIndex; i < this.size(); ++i) {
                    element = this.get(i);
                    element.recalc(0);
                    if (!element.autoplace) continue;
                    element.x = 0.0;
                    this.autoY = element.y = this.furthestY;
                    this.furthestY = Tools.max(this.furthestY, this.autoY + element.height);
                }
                break;
            }
            case 11: {
                GUIElement element;
                int i;
                if (this.size() <= 1 || startIndex != this.size() - 1) {
                    this.autoX = 0.0;
                    this.furthestX = 0.0;
                    for (i = 0; i < startIndex; ++i) {
                        element = this.get(i);
                        if (!element.autoplace) continue;
                        this.autoX = element.x;
                        this.furthestX = Tools.max(this.furthestX, this.autoX + element.width);
                    }
                }
                for (i = startIndex; i < this.size(); ++i) {
                    element = this.get(i);
                    element.recalc(0);
                    if (!element.autoplace) continue;
                    element.x = this.furthestX;
                    element.y = 0.0;
                    this.autoX = element.x;
                    this.furthestX = Tools.max(this.furthestX, this.autoX + element.width);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented autoplace type: " + this.subElementAutoplaceMethod);
            }
        }
    }

    public void setSubElementAutoplaceMethod(byte subElementAutoplaceMethod) {
        this.subElementAutoplaceMethod = subElementAutoplaceMethod;
        this.recalc(0);
    }

    public void remove(GUIElement element) {
        int index = this.indexOf(element);
        if (index != -1) {
            this.remove(index);
        } else if (element.parent == this) {
            element.parent = null;
        }
    }

    public void remove(int index) {
        GUIElement element = this.children.remove(index);
        if (element != null) {
            if (element.parent == this) {
                element.parent = null;
            }
            this.recalc(0);
            for (Predicate<GUIElement> action : this.onRemoveChildActions) {
                action.test(element);
            }
            this.recalc(0);
        }
    }

    public int size() {
        return this.children.size();
    }

    public void clear() {
        for (GUIElement child : (ArrayList)this.children.clone()) {
            this.remove(child);
        }
    }

    public GUIElement get(int index) {
        return this.children.get(index);
    }

    public int indexOf(GUIElement child) {
        int i = 0;
        for (GUIElement element : this.children) {
            if (element == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void linkMouseActivity(GUIElement element) {
        this.linkedMouseActivity.add(element);
        element.linkedMouseActivityReverse.add(this);
    }

    public void unlinkMouseActivity(GUIElement element) {
        this.linkedMouseActivity.remove(element);
        element.linkedMouseActivityReverse.remove(this);
    }

    public void setExternalDeactivation(boolean external, boolean recursive) {
        this.externalDeactivation = external;
        if (recursive) {
            for (GUIElement child : this.children) {
                child.setExternalDeactivation(external, true);
            }
        }
    }

    public void setActive(boolean active) {
        this.setActive(active, false);
    }

    public void setActive(boolean active, boolean external) {
        if (!active && this.externalDeactivation && !external) {
            return;
        }
        this.active = active;
        for (GUIElement element : this.linkedMouseActivity) {
            element.active = active;
        }
    }

    public void setActiveRecursive(boolean active) {
        this.setActive(active, true);
        for (GUIElement child : this.children) {
            child.setActiveRecursive(active);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void keyTyped(char typedChar, int keyCode) {
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.keyTyped(typedChar, keyCode);
        }
    }
}

