/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui;

import com.fantasticsource.fantasticlib.config.FantasticConfig;
import com.fantasticsource.mctools.ClientTickTimer;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.Render;
import com.fantasticsource.mctools.gui.Namespace;
import com.fantasticsource.mctools.gui.element.view.GUIView;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GUIScreen
extends GuiScreen {
    protected static final Field CONFIG_MANAGER_CONFIGS_FIELD = ReflectionTool.getField(ConfigManager.class, "CONFIGS");
    public static final Stack<ScreenEntry> SCREEN_STACK = new Stack();
    public static final FontRenderer FONT_RENDERER = Minecraft.func_71410_x().field_71466_p;
    public static int[] currentScissor;
    public static double mouseX;
    public static double mouseY;
    public static FloatBuffer mcProjection;
    public static FloatBuffer mcModelView;
    private static boolean ignoreClosure;
    public final GUIView root;
    public final GUIView tooltips;
    public ItemStack tooltipStack = null;
    public final ArrayList<Runnable> onClosedActions = new ArrayList();
    public final double textScale;
    public boolean drawStack = true;
    public int pxWidth;
    public int pxHeight;
    public float xPixel;
    public float yPixel;
    private ArrayList<Integer> mouseButtons = new ArrayList();
    private boolean initialized = false;
    public final LinkedHashMap<String, Namespace> namespaces = new LinkedHashMap();

    public GUIScreen() {
        this(1.0);
    }

    public GUIScreen(double textScale) {
        boolean found = false;
        double mul = 1.0;
        for (String s : FantasticConfig.guiSettings.perGUIScaling) {
            String[] tokens = Tools.fixedSplit(s, ",");
            if (!((Object)((Object)this)).getClass().getName().equals(tokens[0])) continue;
            mul = Double.parseDouble(tokens[1]);
            found = true;
        }
        this.textScale = textScale * mul;
        if (!found) {
            String[] entries = new String[FantasticConfig.guiSettings.perGUIScaling.length + 1];
            System.arraycopy(FantasticConfig.guiSettings.perGUIScaling, 0, entries, 0, FantasticConfig.guiSettings.perGUIScaling.length);
            entries[entries.length - 1] = ((Object)((Object)this)).getClass().getName() + ", 1";
            FantasticConfig.guiSettings.perGUIScaling = entries;
            try {
                MCTools.saveConfig("fantasticlib");
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.pxWidth = Display.getWidth();
        this.pxHeight = Display.getHeight();
        this.xPixel = 1.0f / (float)this.pxWidth;
        this.yPixel = 1.0f / (float)this.pxHeight;
        this.root = new GUIView(this, 1.0, 1.0);
        this.tooltips = new GUIView(this, 1.0, 1.0);
    }

    public static Color getIdleColor(Color activeColor) {
        return activeColor.copy().setVF(0.5f * activeColor.vf());
    }

    public static Color getHoverColor(Color activeColor) {
        return activeColor.copy().setVF(0.75f * activeColor.vf());
    }

    public void show() {
        if (Minecraft.func_71410_x().field_71462_r instanceof GUIScreen) {
            this.showStacked();
        } else {
            this.showUnstacked();
        }
    }

    public void showUnstacked() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
    }

    public void showStacked() {
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        if (current instanceof GUIScreen) {
            SCREEN_STACK.push(new ScreenEntry((GUIScreen)current, mouseX, mouseY));
        }
        ignoreClosure = true;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this);
        ignoreClosure = false;
    }

    public static void show(GUIScreen screen) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GUIScreen) {
            GUIScreen.showStacked(screen);
        } else {
            GUIScreen.showUnstacked(screen);
        }
    }

    public static void showUnstacked(GUIScreen screen) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)screen);
    }

    public static void showStacked(GUIScreen screen) {
        GuiScreen current = Minecraft.func_71410_x().field_71462_r;
        if (current instanceof GUIScreen) {
            SCREEN_STACK.push(new ScreenEntry((GUIScreen)current, mouseX, mouseY));
        }
        ignoreClosure = true;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)screen);
        ignoreClosure = false;
    }

    public abstract String title();

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isVisible() {
        return Minecraft.func_71410_x().field_71462_r == this;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        mcProjection = Render.getCurrentProjectionMatrix();
        mcModelView = Render.getCurrentModelViewMatrix();
        if (this.pxWidth != Display.getWidth() || this.pxHeight != Display.getHeight()) {
            this.recalc();
        }
        if (this.drawStack) {
            double mX = GUIScreen.mouseX;
            double mY = GUIScreen.mouseY;
            for (ScreenEntry entry : SCREEN_STACK) {
                GUIScreen.mouseX = entry.mouseX;
                GUIScreen.mouseY = entry.mouseY;
                entry.screen.draw();
            }
            GUIScreen.mouseX = mX;
            GUIScreen.mouseY = mY;
        }
        this.draw();
    }

    public boolean scissor() {
        int w = currentScissor[2] - currentScissor[0];
        int h = currentScissor[3] - currentScissor[1];
        if (w < 1 || h < 1) {
            return false;
        }
        GL11.glScissor((int)currentScissor[0], (int)(this.pxHeight - currentScissor[3]), (int)w, (int)h);
        return true;
    }

    public void draw() {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Render.startOrtho();
        GlStateManager.func_179152_a((float)this.pxWidth, (float)this.pxHeight, (float)1.0f);
        GL11.glEnable((int)3089);
        currentScissor = new int[]{0, 0, this.pxWidth, this.pxHeight};
        this.root.draw();
        currentScissor = new int[]{0, 0, this.pxWidth, this.pxHeight};
        GlStateManager.func_179097_i();
        if (this.isVisible()) {
            this.tooltips.draw();
        }
        this.tooltips.clear();
        GL11.glDisable((int)3089);
        Render.endOrtho();
        GlStateManager.func_179126_j();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        if (this.isVisible() && this.tooltipStack != null) {
            this.renderToolTip(this.tooltipStack);
        }
        this.tooltipStack = null;
    }

    public void func_73866_w_() {
        if (!this.initialized) {
            this.initialized = true;
            this.init();
        }
        try {
            Mouse.setCursorPosition((int)((int)(mouseX * (double)Render.getStoredViewportWidth())), (int)((int)((1.0 - mouseY) * (double)Render.getStoredViewportHeight())));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.mouseButtons.clear();
        this.root.recalc(0);
        Keyboard.enableRepeatEvents((boolean)true);
    }

    protected void init() {
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        if (w == this.field_146294_l && h == this.field_146295_m) {
            return;
        }
        super.func_175273_b(mcIn, w, h);
        this.recalc();
    }

    protected void recalc() {
        this.pxWidth = Display.getWidth();
        this.pxHeight = Display.getHeight();
        this.xPixel = 1.0f / (float)this.pxWidth;
        this.yPixel = 1.0f / (float)this.pxHeight;
        this.root.recalc(0);
    }

    public void func_146274_d() {
        int btn;
        if (!Mouse.isInsideWindow()) {
            Mouse.getDWheel();
            return;
        }
        mouseX = (double)Mouse.getX() / (double)this.field_146297_k.field_71443_c;
        int displayHeight = this.field_146297_k.field_71440_d;
        mouseY = (double)(displayHeight - 1 - Mouse.getY()) / (double)displayHeight;
        int delta = Mouse.getDWheel();
        if (delta != 0) {
            this.root.mouseWheel(delta);
        }
        if ((btn = Mouse.getEventButton()) != -1) {
            if (Mouse.isButtonDown((int)btn)) {
                if (!this.mouseButtons.contains(btn)) {
                    this.mouseButtons.add(btn);
                }
                this.root.mousePressed(btn);
            } else {
                this.mouseButtons.remove((Object)btn);
                this.root.mouseReleased(btn);
            }
        } else {
            for (int b : this.mouseButtons) {
                this.root.mouseDrag(b);
            }
        }
    }

    public void close() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == this) {
            mc.field_71439_g.func_175159_q();
        }
    }

    public final void func_146281_b() {
        if (!ignoreClosure) {
            ClientTickTimer.schedule(0, this::onClosed);
        }
    }

    public void onClosed() {
        for (Runnable action : this.onClosedActions) {
            action.run();
        }
        if (SCREEN_STACK.size() > 0) {
            GUIScreen screen = GUIScreen.SCREEN_STACK.pop().screen;
            this.field_146297_k.func_147108_a((GuiScreen)screen);
            screen.func_175273_b(Minecraft.func_71410_x(), this.field_146294_l, this.field_146295_m);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.root.keyTyped(typedChar, keyCode);
    }

    public GUIScreen addOnClosedActions(Runnable ... actions) {
        this.onClosedActions.addAll(Arrays.asList(actions));
        return this;
    }

    public void renderToolTip(ItemStack stack) {
        ScaledResolution sr = new ScaledResolution(this.field_146297_k);
        super.func_146285_a(stack, Mouse.getX() * sr.func_78326_a() / this.field_146297_k.field_71443_c, sr.func_78328_b() - Mouse.getY() * sr.func_78328_b() / this.field_146297_k.field_71440_d - 1);
    }

    static {
        mouseX = 0.5;
        mouseY = 0.5;
        ignoreClosure = false;
    }

    public static class ScreenEntry {
        public final GUIScreen screen;
        public final double mouseX;
        public final double mouseY;

        public ScreenEntry(GUIScreen screen, double mouseX, double mouseY) {
            this.screen = screen;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
        }
    }
}

