/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.seasons;

import com.ferreusveritas.dynamictrees.api.seasons.ClimateZoneType;
import com.ferreusveritas.dynamictrees.api.seasons.ISeasonGrowthCalculator;
import com.ferreusveritas.dynamictrees.api.seasons.ISeasonManager;
import com.ferreusveritas.dynamictrees.seasons.ISeasonProvider;
import com.ferreusveritas.dynamictrees.seasons.SeasonContext;
import com.ferreusveritas.dynamictrees.seasons.SeasonGrowthCalculatorNull;
import com.ferreusveritas.dynamictrees.seasons.SeasonProviderNull;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SeasonManager
implements ISeasonManager {
    private final Map<Integer, SeasonContext> seasonContextMap = new HashMap<Integer, SeasonContext>();
    private Function<World, Tuple<ISeasonProvider, ISeasonGrowthCalculator>> seasonMapper = w -> new Tuple((Object)new SeasonProviderNull(), (Object)new SeasonGrowthCalculatorNull());
    private static final float TROPICAL_THRESHHOLD = 0.8f;
    private BiPredicate<World, BlockPos> isTropical = (world, rootPos) -> world.func_180494_b(rootPos).func_185353_n() > 0.8f;

    public SeasonManager() {
    }

    public SeasonManager(Function<World, Tuple<ISeasonProvider, ISeasonGrowthCalculator>> seasonMapper) {
        this.seasonMapper = seasonMapper;
    }

    private Tuple<ISeasonProvider, ISeasonGrowthCalculator> createProvider(World world) {
        return this.seasonMapper.apply(world);
    }

    private SeasonContext getContext(World world) {
        return this.seasonContextMap.computeIfAbsent(world.field_73011_w.getDimension(), d -> {
            Tuple<ISeasonProvider, ISeasonGrowthCalculator> tuple = this.createProvider(world);
            return new SeasonContext((ISeasonProvider)tuple.func_76341_a(), (ISeasonGrowthCalculator)tuple.func_76340_b());
        });
    }

    public void setProvider(World world, ISeasonProvider provider, ISeasonGrowthCalculator calc) {
        this.setProvider(world, provider, calc);
    }

    @Override
    public void flushMappings() {
        this.seasonContextMap.clear();
    }

    public void setTropicalPredicate(BiPredicate<World, BlockPos> predicate) {
        this.isTropical = predicate;
    }

    @Override
    public boolean isTropical(World world, BlockPos rootPos) {
        return this.isTropical.test(world, rootPos);
    }

    @Override
    public void updateTick(World world, long worldTicks) {
        this.getContext(world).updateTick(world, worldTicks);
    }

    @Override
    public float getGrowthFactor(World world, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(world);
        return this.isTropical(world, rootPos) ? context.getTropicalGrowthFactor(offset) : context.getTemperateGrowthFactor(offset);
    }

    @Override
    public float getSeedDropFactor(World world, BlockPos rootPos, float offset) {
        SeasonContext context = this.getContext(world);
        return this.isTropical(world, rootPos) ? context.getTropicalSeedDropFactor(offset) : context.getTemperateSeedDropFactor(offset);
    }

    @Override
    public float getFruitProductionFactor(World world, BlockPos rootPos, float offset) {
        if (world == null) {
            return this.getFruitProductionFactorAsScan(world, rootPos, offset);
        }
        SeasonContext context = this.getContext(world);
        return this.isTropical(world, rootPos) ? context.getTropicalFruitProductionFactor(offset) : context.getTemperateFruitProductionFactor(offset);
    }

    @Override
    public Float getSeasonValue(World world, BlockPos pos) {
        return this.getContext(world).getSeasonProvider().getSeasonValue(world, pos);
    }

    @Override
    public boolean shouldSnowMelt(World world, BlockPos pos) {
        return this.getContext(world).getSeasonProvider().shouldSnowMelt(world, pos);
    }

    public float getFruitProductionFactorAsScan(World world, BlockPos rootPos, float offset) {
        if (this.seasonContextMap.size() > 0) {
            boolean tropical;
            int dim = rootPos.func_177958_n();
            float seasonValue = (float)rootPos.func_177956_o() / 64.0f;
            boolean bl = tropical = (float)rootPos.func_177952_p() >= 1.0f;
            if (this.seasonContextMap.containsKey(dim)) {
                SeasonContext context = this.seasonContextMap.get(dim);
                ISeasonGrowthCalculator calculator = context.getCalculator();
                return calculator.calcFruitProduction(Float.valueOf(seasonValue + offset), tropical ? ClimateZoneType.TROPICAL : ClimateZoneType.TEMPERATE);
            }
        }
        return 0.0f;
    }
}

