/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models;

import com.ferreusveritas.dynamictrees.blocks.BlockRootyWater;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.Loader;

public class ModelRootyWater
implements IBakedModel {
    protected IBakedModel rootsModel;
    protected TextureAtlasSprite stillWaterTexture;
    protected TextureAtlasSprite flowWaterTexture;

    public ModelRootyWater(IBakedModel rootsModel) {
        this.rootsModel = rootsModel;
        String textureProvider = Loader.isModLoaded((String)"aquaacrobatics") ? "aquaacrobatics" : "minecraft";
        this.stillWaterTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(textureProvider + ":blocks/water_still");
        this.flowWaterTexture = Minecraft.func_71410_x().func_147117_R().func_110572_b(textureProvider + ":blocks/water_flow");
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (side != null) {
            return quads;
        }
        if (state instanceof IExtendedBlockState) {
            BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
            if (renderLayer == BlockRenderLayer.CUTOUT_MIPPED) {
                quads.addAll(this.rootsModel.func_188616_a(state, side, rand));
            }
            if (renderLayer == BlockRenderLayer.TRANSLUCENT) {
                IExtendedBlockState extState = (IExtendedBlockState)state;
                float yOffset = 0.001f;
                float y0 = ((Float)extState.getValue((IUnlistedProperty)BlockRootyWater.CORNER_HEIGHTS[0])).floatValue() - yOffset;
                float y1 = ((Float)extState.getValue((IUnlistedProperty)BlockRootyWater.CORNER_HEIGHTS[1])).floatValue() - yOffset;
                float y2 = ((Float)extState.getValue((IUnlistedProperty)BlockRootyWater.CORNER_HEIGHTS[2])).floatValue() - yOffset;
                float y3 = ((Float)extState.getValue((IUnlistedProperty)BlockRootyWater.CORNER_HEIGHTS[3])).floatValue() - yOffset;
                TextureAtlasSprite textureatlassprite = this.stillWaterTexture;
                int[] colors = new int[6];
                for (EnumFacing facing : EnumFacing.values()) {
                    int v = (int)(255.0f * LightUtil.diffuseLight((EnumFacing)facing));
                    colors[facing.ordinal()] = 0xFF000000 | v << 16 | v << 8 | v;
                }
                float min = 0.0f;
                float max = 16.0f;
                float p0 = 1.0E-4f;
                float p1 = 0.9999f;
                if (((Boolean)extState.getValue((IUnlistedProperty)BlockRootyWater.RENDER_SIDES[0])).booleanValue()) {
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(0.0f, 0.0f, 1.0f, colors[0], textureatlassprite, min, max), this.vertexToInts(0.0f, 0.0f, 0.0f, colors[0], textureatlassprite, min, min), this.vertexToInts(1.0f, 0.0f, 0.0f, colors[0], textureatlassprite, max, min), this.vertexToInts(1.0f, 0.0f, 1.0f, colors[0], textureatlassprite, max, max)}), 0, EnumFacing.DOWN, textureatlassprite, false, DefaultVertexFormats.field_176600_a));
                }
                if (((Boolean)extState.getValue((IUnlistedProperty)BlockRootyWater.RENDER_SIDES[1])).booleanValue()) {
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(0.0f, y0, 0.0f, colors[1], textureatlassprite, min, min), this.vertexToInts(0.0f, y1, 1.0f, colors[1], textureatlassprite, min, max), this.vertexToInts(1.0f, y2, 1.0f, colors[1], textureatlassprite, max, max), this.vertexToInts(1.0f, y3, 0.0f, colors[1], textureatlassprite, max, min)}), 0, EnumFacing.UP, textureatlassprite, false, DefaultVertexFormats.field_176600_a));
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(0.0f, y0, 0.0f, colors[1], textureatlassprite, min, min), this.vertexToInts(1.0f, y3, 0.0f, colors[1], textureatlassprite, max, min), this.vertexToInts(1.0f, y2, 1.0f, colors[1], textureatlassprite, max, max), this.vertexToInts(0.0f, y1, 1.0f, colors[1], textureatlassprite, min, max)}), 0, EnumFacing.DOWN, textureatlassprite, false, DefaultVertexFormats.field_176600_a));
                }
                if (((Boolean)extState.getValue((IUnlistedProperty)BlockRootyWater.RENDER_SIDES[2])).booleanValue()) {
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(p1, y3, p0, colors[2], this.flowWaterTexture, 8.0f, (1.0f - y3) * 8.0f), this.vertexToInts(p1, 0.0f, p0, colors[2], this.flowWaterTexture, 8.0f, 8.0f), this.vertexToInts(p0, 0.0f, p0, colors[2], this.flowWaterTexture, 0.0f, 8.0f), this.vertexToInts(p0, y0, p0, colors[2], this.flowWaterTexture, 0.0f, (1.0f - y0) * 8.0f)}), 0, EnumFacing.NORTH, this.flowWaterTexture, false, DefaultVertexFormats.field_176600_a));
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(p0, y3, p0, colors[2], this.flowWaterTexture, 8.0f, (1.0f - y3) * 8.0f), this.vertexToInts(p0, 0.0f, p0, colors[2], this.flowWaterTexture, 8.0f, 8.0f), this.vertexToInts(p1, 0.0f, p0, colors[2], this.flowWaterTexture, 0.0f, 8.0f), this.vertexToInts(p1, y0, p0, colors[2], this.flowWaterTexture, 0.0f, (1.0f - y0) * 8.0f)}), 0, EnumFacing.SOUTH, this.flowWaterTexture, false, DefaultVertexFormats.field_176600_a));
                }
                if (((Boolean)extState.getValue((IUnlistedProperty)BlockRootyWater.RENDER_SIDES[3])).booleanValue()) {
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(p0, y1, p1, colors[3], this.flowWaterTexture, 8.0f, (1.0f - y1) * 8.0f), this.vertexToInts(p0, 0.0f, p1, colors[3], this.flowWaterTexture, 8.0f, 8.0f), this.vertexToInts(p1, 0.0f, p1, colors[3], this.flowWaterTexture, 0.0f, 8.0f), this.vertexToInts(p1, y2, p1, colors[3], this.flowWaterTexture, 0.0f, (1.0f - y2) * 8.0f)}), 0, EnumFacing.SOUTH, this.flowWaterTexture, false, DefaultVertexFormats.field_176600_a));
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(p1, y1, p1, colors[3], this.flowWaterTexture, 8.0f, (1.0f - y1) * 8.0f), this.vertexToInts(p1, 0.0f, p1, colors[3], this.flowWaterTexture, 8.0f, 8.0f), this.vertexToInts(p0, 0.0f, p1, colors[3], this.flowWaterTexture, 0.0f, 8.0f), this.vertexToInts(p0, y2, p1, colors[3], this.flowWaterTexture, 0.0f, (1.0f - y2) * 8.0f)}), 0, EnumFacing.NORTH, this.flowWaterTexture, false, DefaultVertexFormats.field_176600_a));
                }
                if (((Boolean)extState.getValue((IUnlistedProperty)BlockRootyWater.RENDER_SIDES[4])).booleanValue()) {
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(p0, y0, p0, colors[4], this.flowWaterTexture, 8.0f, (1.0f - y0) * 8.0f), this.vertexToInts(p0, 0.0f, p0, colors[4], this.flowWaterTexture, 8.0f, 8.0f), this.vertexToInts(p0, 0.0f, p1, colors[4], this.flowWaterTexture, 0.0f, 8.0f), this.vertexToInts(p0, y1, p1, colors[4], this.flowWaterTexture, 0.0f, (1.0f - y1) * 8.0f)}), 0, EnumFacing.WEST, this.flowWaterTexture, false, DefaultVertexFormats.field_176600_a));
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(p0, y0, p1, colors[4], this.flowWaterTexture, 8.0f, (1.0f - y0) * 8.0f), this.vertexToInts(p0, 0.0f, p1, colors[4], this.flowWaterTexture, 8.0f, 8.0f), this.vertexToInts(p0, 0.0f, p0, colors[4], this.flowWaterTexture, 0.0f, 8.0f), this.vertexToInts(p0, y1, p0, colors[4], this.flowWaterTexture, 0.0f, (1.0f - y1) * 8.0f)}), 0, EnumFacing.EAST, this.flowWaterTexture, false, DefaultVertexFormats.field_176600_a));
                }
                if (((Boolean)extState.getValue((IUnlistedProperty)BlockRootyWater.RENDER_SIDES[5])).booleanValue()) {
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(p1, y2, p1, colors[5], this.flowWaterTexture, 8.0f, (1.0f - y2) * 8.0f), this.vertexToInts(p1, 0.0f, p1, colors[5], this.flowWaterTexture, 8.0f, 8.0f), this.vertexToInts(p1, 0.0f, p0, colors[5], this.flowWaterTexture, 0.0f, 8.0f), this.vertexToInts(p1, y3, p0, colors[5], this.flowWaterTexture, 0.0f, (1.0f - y3) * 8.0f)}), 0, EnumFacing.EAST, this.flowWaterTexture, false, DefaultVertexFormats.field_176600_a));
                    quads.add(new BakedQuad(Ints.concat((int[][])new int[][]{this.vertexToInts(p1, y2, p0, colors[5], this.flowWaterTexture, 8.0f, (1.0f - y2) * 8.0f), this.vertexToInts(p1, 0.0f, p0, colors[5], this.flowWaterTexture, 8.0f, 8.0f), this.vertexToInts(p1, 0.0f, p1, colors[5], this.flowWaterTexture, 0.0f, 8.0f), this.vertexToInts(p1, y3, p1, colors[5], this.flowWaterTexture, 0.0f, (1.0f - y3) * 8.0f)}), 0, EnumFacing.WEST, this.flowWaterTexture, false, DefaultVertexFormats.field_176600_a));
                }
            }
        }
        return quads;
    }

    protected int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.func_94214_a((double)u)), Float.floatToRawIntBits(texture.func_94207_b((double)v)), 0};
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.stillWaterTexture;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

