/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event;

import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.blocks.BlockDynamicSapling;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.ItemUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class VanillaSaplingEventHandler {
    @SubscribeEvent
    public void onPlayerPlaceBlock(BlockEvent.PlaceEvent event) {
        IBlockState blockState = event.getPlacedBlock();
        if (!TreeRegistry.saplingReplacers.containsKey(blockState)) {
            return;
        }
        Species species = TreeRegistry.saplingReplacers.get(blockState);
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        world.func_175698_g(pos);
        if (!species.plantSapling(world, pos)) {
            ItemUtils.spawnItemStack(world, pos, species.getSeedStack(1));
        }
    }

    @SubscribeEvent
    public void onSaplingGrowTree(SaplingGrowTreeEvent event) {
        BlockPos pos;
        World world = event.getWorld();
        IBlockState blockState = world.func_180495_p(pos = event.getPos());
        if (!TreeRegistry.saplingReplacers.containsKey(blockState)) {
            return;
        }
        Species species = TreeRegistry.saplingReplacers.get(blockState);
        world.func_175698_g(pos);
        event.setResult(Event.Result.DENY);
        if (species.isValid() && BlockDynamicSapling.canSaplingStay(world, species, pos)) {
            species.transitionToTree(world, pos);
        }
    }
}

