/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.event;

import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDiscProviderUniversal;
import com.ferreusveritas.dynamictrees.worldgen.TreeGenerator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PoissonDiscEventHandler {
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            TreeGenerator.getTreeGenerator().getCircleProvider().unloadWorld(world);
        }
    }

    @SubscribeEvent
    public void onChunkDataLoad(ChunkDataEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            byte[] circleData = event.getData().func_74770_j("GTCD");
            PoissonDiscProviderUniversal cp = TreeGenerator.getTreeGenerator().getCircleProvider();
            cp.setChunkPoissonData(world, event.getChunk().field_76635_g, 0, event.getChunk().field_76647_h, circleData);
        }
    }

    @SubscribeEvent
    public void onChunkDataSave(ChunkDataEvent.Save event) {
        World world = event.getWorld();
        PoissonDiscProviderUniversal cp = TreeGenerator.getTreeGenerator().getCircleProvider();
        byte[] circleData = cp.getChunkPoissonData(world, event.getChunk().field_76635_g, 0, event.getChunk().field_76647_h);
        NBTTagByteArray circleByteArray = new NBTTagByteArray(circleData);
        event.getData().func_74782_a("GTCD", (NBTBase)circleByteArray);
        if (!event.getChunk().func_177410_o()) {
            cp.unloadChunkPoissonData(world, event.getChunk().field_76635_g, 0, event.getChunk().field_76647_h);
        }
    }
}

