/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.api.client;

import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelHelper {
    public static void regModel(TreeFamily tree) {
        BlockSurfaceRoot surfaceRoot;
        BlockBranch blockBranch = tree.getDynamicBranch();
        ModelResourceLocation modelLocation = ModelHelper.getBranchModelResourceLocation(blockBranch);
        ModelHelper.setGenericStateMapper(blockBranch, modelLocation);
        if (blockBranch instanceof BlockBranchThick) {
            ModelHelper.setGenericStateMapper(((BlockBranchThick)blockBranch).otherBlock, modelLocation);
        }
        if ((surfaceRoot = tree.getSurfaceRoots()) != null) {
            ModelLoader.setCustomStateMapper((Block)surfaceRoot, (IStateMapper)new StateMap.Builder().func_178442_a(surfaceRoot.getIgnorableProperties()).func_178441_a());
        }
    }

    private static ModelResourceLocation getBranchModelResourceLocation(BlockBranch blockBranch) {
        ResourceLocation family = blockBranch.getFamily().getName();
        ResourceLocation resloc = new ResourceLocation(family.func_110624_b(), family.func_110623_a() + "branch");
        return new ModelResourceLocation(resloc, null);
    }

    public static void setGenericStateMapper(Block block, ModelResourceLocation modelLocation) {
        ModelLoader.setCustomStateMapper((Block)block, state -> block.func_176194_O().func_177619_a().stream().collect(Collectors.toMap(b -> b, b -> modelLocation)));
    }

    public static void regModel(Block block) {
        if (block != Blocks.field_150350_a) {
            ModelHelper.regModel(Item.func_150898_a((Block)block));
        }
        if (block instanceof BlockBranchThick) {
            Item item = Item.func_150898_a((Block)((BlockBranchThick)block).otherBlock);
            ModelHelper.regModel(item, 0, block.getRegistryName());
        }
    }

    public static void regModel(Item item) {
        ModelHelper.regModel(item, 0);
    }

    public static void regModel(Item item, int meta) {
        ModelHelper.regModel(item, meta, item.getRegistryName());
    }

    public static void regModel(Item item, int meta, ResourceLocation customResourceLocation) {
        if (item != null) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(customResourceLocation, "inventory"));
        }
    }

    public static void regColorHandler(Block block, IBlockColor blockColor) {
        Minecraft.func_71410_x().func_184125_al().func_186722_a(blockColor, new Block[]{block});
    }

    public static void regColorHandler(Item item, IItemColor itemColor) {
        Minecraft.func_71410_x().getItemColors().func_186730_a(itemColor, new Item[]{item});
    }
}

