/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.util;

import dev.satyrn.wolfarmor.api.util.ILogHelper;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.LoggingException;

public class LogHelper
implements ILogHelper {
    private Logger logger;

    public LogHelper() {
    }

    LogHelper(@Nonnull Logger logger) {
        this.initializeLogger(logger);
    }

    @Override
    public void initializeLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void log(@Nonnull Level level, @Nonnull String message) {
        if (this.logger == null) {
            throw new LoggingException("Logger has not been initialized");
        }
        this.logger.log(level, message);
    }

    @Override
    public void log(@Nonnull Level level, @Nonnull Throwable ex) {
        this.log(level, ex, level);
    }

    @Override
    public void log(@Nonnull Level level, @Nonnull Throwable ex, @Nonnull Level stackTraceLevel) {
        this.log(level, ex.getMessage());
        for (StackTraceElement stackTraceElement : ex.getStackTrace()) {
            this.log(stackTraceLevel, stackTraceElement);
        }
    }

    @Override
    public void log(@Nonnull Level level, @Nonnull Object obj) {
        this.log(level, obj.toString());
    }

    @Override
    public void info(@Nonnull String message) {
        this.log(Level.INFO, message);
    }

    @Override
    public void warning(@Nonnull String message) {
        this.log(Level.WARN, message);
    }

    @Override
    public void warning(@Nonnull Exception ex) {
        this.log(Level.WARN, ex, Level.DEBUG);
    }

    @Override
    public void error(@Nonnull String message) {
        this.log(Level.ERROR, message);
    }

    @Override
    public void error(@Nonnull Exception ex) {
        this.log(Level.ERROR, ex, Level.DEBUG);
    }

    @Override
    public void fatal(@Nonnull String message) {
        this.log(Level.FATAL, message);
    }

    @Override
    public void fatal(@Nonnull Throwable ex) {
        this.log(Level.FATAL, ex, Level.DEBUG);
    }

    @Override
    public void debug(@Nonnull String message) {
        this.log(Level.DEBUG, message);
    }

    @Override
    public void debug(@Nonnull Object obj) {
        this.log(Level.DEBUG, obj);
    }

    @Override
    public void trace(@Nonnull String message) {
        this.log(Level.TRACE, message);
    }

    @Override
    public void trace(@Nonnull Object obj) {
        this.log(Level.TRACE, obj);
    }
}

