/*
 * Decompiled with CFR 0.152.
 */
package dev.satyrn.wolfarmor.common.network.packets;

import dev.satyrn.wolfarmor.common.network.MessageBase;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UpdatePotionEffectMessage
extends MessageBase.ClientMessageBase<UpdatePotionEffectMessage> {
    private int entityId;
    private byte effectId;
    private byte amplifier;
    private int duration;
    private byte flags;

    public UpdatePotionEffectMessage() {
    }

    public UpdatePotionEffectMessage(int entityId, PotionEffect potionEffect) {
        this.entityId = entityId;
        this.effectId = (byte)(Potion.func_188409_a((Potion)potionEffect.func_188419_a()) & 0xFF);
        this.amplifier = (byte)(potionEffect.func_76458_c() & 0xFF);
        this.duration = Math.min(Short.MAX_VALUE, potionEffect.func_76459_b());
        this.flags = 0;
        if (potionEffect.func_82720_e()) {
            this.flags = (byte)(this.flags | 1);
        }
        if (potionEffect.func_188418_e()) {
            this.flags = (byte)(this.flags | 2);
        }
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.entityId = buffer.func_150792_a();
        this.effectId = buffer.readByte();
        this.amplifier = buffer.readByte();
        this.duration = buffer.func_150792_a();
        this.flags = buffer.readByte();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        buffer.func_150787_b(this.entityId);
        buffer.writeByte((int)this.effectId);
        buffer.writeByte((int)this.amplifier);
        buffer.func_150787_b(this.duration);
        buffer.writeByte((int)this.flags);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesShowParticles() {
        return (this.flags & 2) == 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getIsAmbient() {
        return (this.flags & 1) == 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isMaxDuration() {
        return this.duration == Short.MAX_VALUE;
    }

    @Override
    protected IMessage process(EntityPlayer player, Side side) {
        Potion potion;
        Entity entity = player.func_130014_f_().func_73045_a(this.entityId);
        if (entity instanceof EntityLivingBase && (potion = Potion.func_188412_a((int)(this.effectId & 0xFF))) != null) {
            PotionEffect potioneffect = new PotionEffect(potion, this.duration, (int)this.amplifier, this.getIsAmbient(), this.doesShowParticles());
            potioneffect.func_100012_b(this.isMaxDuration());
            ((EntityLivingBase)entity).func_70690_d(potioneffect);
        }
        return null;
    }
}

