/*
 * Decompiled with CFR 0.152.
 */
package jaredbgreat.dldungeons.nbt.tags;

import jaredbgreat.dldungeons.nbt.NBTType;
import jaredbgreat.dldungeons.nbt.tags.Enchantment;
import jaredbgreat.dldungeons.nbt.tags.ITag;
import jaredbgreat.dldungeons.nbt.tags.NBTBoolean;
import jaredbgreat.dldungeons.nbt.tags.NBTByte;
import jaredbgreat.dldungeons.nbt.tags.NBTByteArray;
import jaredbgreat.dldungeons.nbt.tags.NBTCompound;
import jaredbgreat.dldungeons.nbt.tags.NBTDouble;
import jaredbgreat.dldungeons.nbt.tags.NBTFloat;
import jaredbgreat.dldungeons.nbt.tags.NBTFromJsonWrapper;
import jaredbgreat.dldungeons.nbt.tags.NBTGroup;
import jaredbgreat.dldungeons.nbt.tags.NBTInt;
import jaredbgreat.dldungeons.nbt.tags.NBTIntArray;
import jaredbgreat.dldungeons.nbt.tags.NBTList;
import jaredbgreat.dldungeons.nbt.tags.NBTLong;
import jaredbgreat.dldungeons.nbt.tags.NBTShort;
import jaredbgreat.dldungeons.nbt.tags.NBTString;
import jaredbgreat.dldungeons.nbt.tags.NBTuuid;
import jaredbgreat.dldungeons.util.parser.Tokenizer;
import java.util.HashMap;
import java.util.Locale;

public final class Tags {
    static final HashMap<String, ITag> registry = new HashMap();

    private Tags() {
    }

    public static ITag makeITag(String line, Tokenizer tokens) {
        ITag out;
        NBTType type = NBTType.valueOf(tokens.getToken(1).toUpperCase(Locale.ROOT));
        switch (type) {
            case BOOLEAN: {
                NBTBoolean nBTBoolean = new NBTBoolean(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
            }
            case BYTE: {
                out = new NBTByte(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case BYTE_ARRAY: {
                out = new NBTByteArray(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case COMPOUND: {
                out = new NBTCompound(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case DOUBLE: {
                out = new NBTDouble(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case FLOAT: {
                out = new NBTFloat(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case LIST: {
                out = new NBTList(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case GROUP: {
                out = new NBTGroup(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case INT: {
                out = new NBTInt(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case INT_ARRAY: {
                out = new NBTIntArray(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case LONG: {
                out = new NBTLong(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case SHORT: {
                out = new NBTShort(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case STRING: {
                out = new NBTString(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case UUID: {
                out = new NBTuuid(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case ENCH: {
                out = new Enchantment(tokens.getToken(0), tokens.getToken(2), tokens.getToken(3));
                break;
            }
            case JSON: {
                String[] s = line.split("\\s+", 3);
                if (s.length == 3) {
                    out = new NBTFromJsonWrapper(tokens.getToken(0), s[2]);
                    break;
                }
                out = null;
                break;
            }
            default: {
                out = null;
            }
        }
        if (out != null) {
            registry.put(tokens.getToken(0), out);
        }
        return out;
    }

    public static ITag getTag(String label) {
        return registry.get(label);
    }
}

