/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.realistictorches.blocks;

import com.chaosthedude.realistictorches.blocks.BlockMovingLightSource;
import com.chaosthedude.realistictorches.blocks.BlockTorchLit;
import com.chaosthedude.realistictorches.blocks.BlockTorchSmoldering;
import com.chaosthedude.realistictorches.blocks.BlockTorchUnlit;
import com.chaosthedude.realistictorches.blocks.te.TEMovingLightSource;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class RealisticTorchesBlocks {
    public static final List<Block> REGISTRY = new ArrayList<Block>();
    public static BlockTorchUnlit torchUnlit;
    public static BlockTorchLit torchLit;
    public static BlockTorchSmoldering torchSmoldering;
    public static BlockMovingLightSource movingLightSource;

    public static void register() {
        torchUnlit = RealisticTorchesBlocks.registerBlock(new BlockTorchUnlit(), "torch_unlit");
        torchLit = RealisticTorchesBlocks.registerBlock(new BlockTorchLit(), "torch_lit");
        torchSmoldering = RealisticTorchesBlocks.registerBlock(new BlockTorchSmoldering(), "torch_smoldering");
        movingLightSource = RealisticTorchesBlocks.registerBlock(new BlockMovingLightSource(), "moving_light_source");
        GameRegistry.registerTileEntity(TEMovingLightSource.class, (String)"te_moving_light_source");
    }

    protected static <T extends Block> T registerBlock(T blockType, String name) {
        T block = blockType;
        block.setRegistryName(name);
        ForgeRegistries.BLOCKS.register(block);
        ForgeRegistries.ITEMS.register(new ItemBlock(block).setRegistryName(name));
        REGISTRY.add(block);
        return block;
    }
}

